<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteLoandetail", "function deleteLoandetail(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
			
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
			  
              'url'  : $('#liveSite').val()+'index.php?r=hr/loandetail/deleteLoandetail',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    reloadTable('#tbl_employee_loan_details');
                    t8.success('Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs->registerScript("loadLoandetails", "function loadLoandetails(){  
    $('#tbl_employee_loan_details').DataTable().destroy();  
    filterDataTable(); 
};", CClientScript::POS_HEAD);

$cs->registerScript("loadloandetails", '
      function filterDataTable()
    {
        var table_id ="#tbl_employee_loan_details";
        var employee_id= $("#loanemployee_id").val();
        var status  = $("#status").val();
        var branch_id = $("#loan_branch_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/loandetail/GetLoanDetails') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "status" : status,
                    "branch_id" : branch_id
                },
                cache : false,
            },
            columns: [            
                {className: "" },
                {className: ""},
                {className: ""},
                {className: "text-right"},
                {className: "text-right"},
                {className: ""},
                {className: ""},
                {className: ""},
                {className: ""},
                {className: "text-right"},
                {className: ""}, 
            ],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            bSort: false,            
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
	}	
		
    $(document).ready(function() {  	
      filterDataTable();
        materializing(".material"); 
    });', CClientScript::POS_HEAD);
$current_date = date('Y-m-d');
//outstanding
$loan_amount = EmployeeLoanDetail::model()->with('employeedetail')->find(array('select' => 'sum(loan_amount) as loan_amount,sum(loan_repayment) as loan_repayment ', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" AND (loan_status = "14" or  loan_status = "15")'));
if (!empty($loan_amount) && $loan_amount->loan_amount > 0) {
    $outstanding = $loan_amount->loan_amount - $loan_amount->loan_repayment;
}
$totaloan_amount = EmployeeLoanDetail::model()->with('employeedetail')->find(array('select' => 'sum(loan_amount) as loan_amount', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" AND (loan_status = "14" or  loan_status = "15" or  loan_status = "16")'));

// $ongoing_amount = EmployeeLoanDetail::model()->with('employeedetail')->find(array('select'=>'sum(loan_monthly_payment) as loan_monthly_payment','condition'=>'employeedetail.branch_or_sponsor_id="'.$branch.'" AND  (loan_status = "14"  or  loan_status = "15") AND repayment_start_date<="'.$current_date.'"'));

$sql = 'SELECT 
            SUM(
                CASE 
                    WHEN (loan_amount - loan_repayment) < loan_monthly_payment 
                         THEN (loan_amount - loan_repayment)
                    ELSE loan_monthly_payment 
                END
            ) AS total_monthly_installments
        FROM 
            erp_hr_employee_loan_detail L
            JOIN erp_hr_employee E  ON E.id= L.employee_id
        WHERE 
            E.branch_or_sponsor_id="' . $branch . '" AND  (L.loan_status = "14"  or  L.loan_status = "15") AND L.repayment_start_date<="' . $current_date . '"';
$ongoing_amount = Yii::app()->db->createCommand($sql)->queryScalar();
?>
<style>
    #employeeloanindexdropdown .material-select-label {
        display: none;
    }
</style>

<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[11].approve_reject !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/loandetail/approvebyhr&final_level=" + datas[11].final_leve1 + "&level=" + datas[11].level_no + "&id=" + datas[11].id, "Approve/Reject Loan", "xl");
                }
            };
        }
        if (datas[11].approval_document !== 0) {
            items.download = {
                name: "Loan Approval Document",
                icon: "fa-print",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/loandetail/loanapprovaldocument&id=" + datas[11].en_id, "_blank");
                }
            };
        }
        if (datas[11].edit_loan !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/loandetail/editloandetail&id=" + datas[11].id, "EDIT EMPLOYEE LOAN DETAILS", "xl");
                }
            };
        }
        if (datas[11].delete_loan !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                    deleteLoandetail(datas[11].id);
                }
            };
        }
        if (datas[11].view_loan !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/loandetail/view&id=" + datas[11].id, "View Loan Details", "lg");
                }
            };
        }
        if (datas[11].loan_payment !== 0) {
            items.payment = {
                name: "Loan Payment",
                icon: "fa-money",
                callback: function () {
                    loadPopupModal("hr/loandetail/loanpayment&id="+ datas[11].id, "Loan Payment", "md");
                }
            };
        }
        if (datas[11].direct_approval !== 0) {
            items.adminapproval = {
                name: "Direct Approval",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/loandetail/approvebyhr&final_level=Y&level=" + datas[11].last_level + "&id=" + datas[11].id, "Approve/Reject Loan", "xl");
                }
            };
        }
        if (datas[11].approval_hierarchy !== 0) {
            items.Hierarchy = {
                name: "Approval Hierarchy",
                icon: "fa-book",
                callback: function () {
                    loadPopupModal("hr/loandetail/approvalhierarchy&function_type=2&employee_id=" + datas[11].employee_id, "Employee Hierarchy", "md");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>

<div class="row">
    <div class="col-md-12">
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingOne">
                    <h4 class="panel-title">
                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Loan Summary
                        </a>
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body">
                        <section class="panel">
                            <div class="panel-body">
                                <div class="row sa-count-wrp">

                                    <div class="col-md-4 col-sm-6">
                                        <div class="counter green">
                                            <h3 style="font-weight: bold">Outstanding Balance</h3>
                                            <span class="counter-value"><?php echo Yii::app()->numberFormatter->formatCurrency($outstanding, " ") ?></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-sm-6">
                                        <div class="counter green">
                                            <h3 style="font-weight: bold">Ongoing Loan</h3>
                                            <span class="counter-value"><?php echo Yii::app()->numberFormatter->formatCurrency($ongoing_amount, " ") ?><span style="font-size: 11px;">/PER MONTH</span></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-sm-6">
                                        <div class="counter green">
                                            <h3 style="font-weight: bold">Total Loan</h3>
                                            <span class="counter-value"><?php echo Yii::app()->numberFormatter->formatCurrency($totaloan_amount->loan_amount, " ") ?></span>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </section>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Loan Details
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeloanindexdropdown">   
                <span class="col-sm-3 pull-right">  
                    <?php
                    $dropdown_list = array();
                    $model_approval_status = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select' => 'max(max_level) as max_level', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and functionality_id="2"'));
                    $max_level = 0;
                    if (!empty($model_approval_status)) {
                        $max_level = $model_approval_status->max_level;
                    }

                    $selected = 'H';
                    if ($max_level <= 1) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 2) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 3) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 4) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Confirmed",
                            9 => "Level 4 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 5) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Confirmed",
                            9 => "Level 4 Rejected",
                            10 => "Level 5 Confirmed",
                            11 => "Level 5 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    }

                    $dropdown_list['H'] = 'Waiting For HR Approval';
                    $dropdown_list['14'] = 'Payment Released';
                    $dropdown_list['15'] = 'Repayment Pending';
                    $dropdown_list['16'] = 'Repayment Completed';
                    echo CHtml::dropdownlist('status', $selected, $dropdown_list, array('title' => 'Status', 'data-search' => true, 'multiple' => true, 'onchange' => 'loadLoandetails();'));
                    ?>
                </span>
                <span class="col-sm-3 pull-right">  
                    <?php echo CHtml::dropdownlist('loanemployee_id', '', EmployeeLoanDetail::getEmployee($branch), array('prompt' => 'All Employee', 'title' => 'Please Select Employee', 'data-search' => true, 'onchange' => 'loadLoandetails();')); ?>                   
                </span>
            </div>
            <input type="hidden" id="loan_branch_id" name="loan_branch_id" value="<?php echo $branch; ?>"/>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_add']) || Yii::app()->user->authorised_user == 1) { ?>
                  <a class="ad-btn" onclick="loadPopupModal('hr/loandetail/create&id=<?php echo $branch; ?>', 'Add New Loan', 'xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>                
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employee_loan_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Loan Amount</th>  
                        <th>Monthly Payment</th>  
                        <th>No of inst.</th>
                        <th>Repayment Start</th>
                        <th>Apply Date</th>
                        <th>Loan Date</th>
                        <th>Amount Paid</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>      