<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadleavesettlement", '
    $(document).ready(function() {
        var table_id ="#tbl_employeeleavesettlement_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetEmployeeLeaveSettlement') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[13].settlement_approve !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/leave/approveleavesettlement&id=" + datas[13].id, "Approve Leave Settlement", "xl");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame"> Employee Leave Settlement
        <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_settlement_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <div class="pull-right">
             <a class="ad-btn" onclick="loadPopupModal('hr/leave/leavesettlementsingle', 'Add Leave Settlement', 'lg');">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            </div>
        <?php } ?>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employeeleavesettlement_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Apply Date</th>
                        <th>Date of Leaving</th>
                        <th>Service Days</th>  
                        <th>Available leaves</th>
                        <th>Encashed leaves</th>
                        <th>Balance Leave</th>
                        <th>Leave Salary</th>
                        <th>Other Payments</th>
                        <th>Total Amount</th>
                        <th>Status</th>                                                
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
