<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadLeave", '
    $(document).ready(function() {
        var table_id ="#tbl_applyleave_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetMasterLeave') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                if (aData[5].apply_status ==1)  {  
                    $("td", nRow).addClass("bg-danger");
                } 
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[5].apply_leave !== 0) {
            items.edit = {
                name: "Leave",
                icon: "fa-calendar",
                callback: function () {
                    loadPopupModal("hr/leave/applyleave&id="+datas[5].id + "&eid=" + datas[5].eid + "&leave=" + datas[5].balance_leave, "Apply Leave", "xl");           
                }
            };
        }
        if (datas[5].apply_encash !== 0) {
            items.view = {
                name: "Encashment",
                icon: "fa-money",
                callback: function () {
                    loadPopupModal("hr/leave/applyleaveencashment&id="+datas[5].id + "&eid=" + datas[5].eid + "&leave=" + datas[5].balance_leave, "Apply Leave Encashment", "xl");
                }
            };
        }
        if (datas[5].leave_history !== 0) {
            items.view = {
                name: "Waiting For Approval",
                icon: "fa-history",
                callback: function () {
                    loadPopupModal("hr/leave/appliedleavehistory&id="+datas[5].id + "&eid=" + datas[5].eid + "&leave=" + datas[5].balance_leave, "Applied Leaves", "xl");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
             Apply Leave
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_applyleave_details">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Type of Leave</th>
                            <th>Opening Leave</th>
                            <th>Leave Taken</th>  
                            <th>Current Leave</th>                                                 
                        </tr>
                    </thead>
                </table>
                <div class="color-indicator pull-left">
                    <span style="display: inline-block;width:30px;height:30px;background:#fcd4d4; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Applied</span>
                </div>
            </div>
        </div>
    </section>
