<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("leavehistorydetails", "function leavehistorydetails(){  
    $('#tbl_leave_details').DataTable().destroy();
        var status       = $('#status').val();
        var from_date    = $('#team_fromdate').val();
        var date_from = from_date.split('/').reverse().join('-');
        var to_date    = $('#team_todate').val();
        var date_to = to_date.split('/').reverse().join('-');
        filterDataTable(status,date_from,date_to);  
};", CClientScript::POS_HEAD);

$cs->registerScript("loadLeave", 'function filterDataTable(status,date_from,date_to){		
        var table_id ="#tbl_leave_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetLeaveHistory') . '",
                type: "POST",
					 "data" : {                  
                    "status" : status,
                    "from_date" : date_from,
                    "date_to" : date_to
                },
                cache : false,
            },
            order: [[ 3, "desc" ]],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();	
		
	}
    $(document).ready(function() {
        var status       = $("#status").val();	
        var from_date    = $("#team_fromdate").val();
        var date_from = from_date.split("/").reverse().join("-");
        var to_date    = $("#team_todate").val();
        var date_to = to_date.split("/").reverse().join("-");
        filterDataTable(status,date_from,date_to);  
    });', CClientScript::POS_HEAD);


$cs->registerScript("cancelleaves", "function cancelleaves(id){           
    jConfirm('Do you want to cancel the leave?', 'Confirmation Dialog', function(r) {
        if (r == true) {
            jQuery.ajax({
                  'type': 'post',
                         'dataType': 'json',
                          'url': '" . Yii::app()->createUrl('hr/leave/cancelleaves') . "',
                             'data': {'id':id}  ,
                         'cache': false,
                         'success': function(data) { 
                            reloadTable('#tbl_leave_details');                      

                         }
            });
        }
                         
});
}", CClientScript::POS_HEAD);

$cs->registerScript("cancelleave", "function cancelleave(leave_id){
    jConfirm('Do you want to cancel the leave?', 'Confirmation Dialog', function(r) {
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'dataType': 'json',
                'url': '" . Yii::app()->createUrl('hr/leave/cancelleave') . "',
                'data': {'id':leave_id}  ,
                'cache': false,
                'success': function(data) { 
                    if(data.status=='success'){
                        t8.success('Leave Cancelled');
                        reloadTable('#tbl_leave_details');         
                    }else if(data.status=='error'){
                         t8.error('Leave cannot be cancelled as it is already approved');
                    }
                }
            });
        }                       
    });
}", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[12].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/leave/editleave&id=" + datas[12].id, 'Edit Leave', "lg");
                }
            };
        }
        if (datas[12].delete_button !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                    cancelleave(datas[12].id);
                }
            };
        }
        if (datas[12].view_button !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/leave/viewleavedetails&id=" + datas[12].id, 'Leave Details', "lg");
                }
            };
        }
        if (datas[12].download_button !== 0) {
            items.download = {
                name: "Approval Document",
                icon: "fa-download",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/leave/downloadDocument&frm=1&id=" + datas[12].id, "_blank");
                }
            };
        }
        if (datas[12].download_certificate !== 0) {
            items.medicaldownload = {
                name: "Medical Document",
                icon: "fa-download",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/leave/downloadDocument&frm=2&id=" + datas[12].id, "_blank");
                }
            };
        }
        if (datas[12].upload_certificate !== 0) {
            items.upload = {
                name: "Upload",
                icon: "fa-upload",
                callback: function () {
                    loadPopupModal("hr/leave/uploadleavedocument&id=" + datas[12].id, 'Upload Document', "lg");
                }
            };
        }
        if (datas[12].cancel_button !== 0) {
            items.cancel = {
                name: "Cancel",
                icon: "fa-ban",
                callback: function () {
                    loadPopupModal("hr/leave/leavecancelrequest&id=" + datas[12].id, 'Leave Cancel Request', "lg");
                }
            };
        }
        if (datas[12].cancel_button_1 !== 0) {
            items.cancel1 = {
                name: "Cancel",
                icon: "fa-ban",
                callback: function () {
                    loadPopupModal("hr/leave/leavecancelrequest&id=" + datas[12].id, 'Leave Cancel Request', "lg");
                }
            };
        }
        if (datas[12].cancel_button_2 !== 0) {
            items.cancel2 = {
                name: "Cancel",
                icon: "fa-ban",
                callback: function () {
                    loadPopupModal("hr/leave/leavecancelrequest&id=" + datas[12].id, 'Leave Cancel Request', "lg");
                }
            };
        }
        if (datas[12].cancel_button_3 !== 0) {
            items.cancel3 = {
                name: "Cancel",
                icon: "fa-ban",
                callback: function () {
                    loadPopupModal("hr/leave/leavecancelrequest&id=" + datas[12].id, 'Leave Cancel Request', "lg");
                }
            };
        }
        if (datas[12].copy_leave !== 0) {
            items.copy = {
                name: "Copy Leave",
                icon: "fa-copy",
                callback: function () {
                    loadPopupModal("hr/leave/copyleave&id=" + datas[12].id, 'Copy Leave Details', "xl");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }

</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-sign-out"></i> -->
        Leave History
        <div class="pull-right" style="display: flex;">
            <?php
            $model_employee = User::model()->findByPk(Yii::app()->user->id);
            $employee_id = $model_employee->employee_id;
            $model_employee_detail = Employee::model()->findByPk($employee_id);
            $model_approval_status = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="1"'));
            $dropdown_list = array();
            $max_level = '';
            if (!empty($model_approval_status)) {
                $max_level = $model_approval_status->max_level;
            }
            if ($max_level <= 1) {
                $dropdown_list = array(
                    1 => "Saved/Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Cancel Request- Applied",
                    15 => "Cancel Request -Level 1 Confirmed",
                    16 => "Cancel Request -Level 1 Rejected",
                    25 => "Cancel Request -Approved",
                    26 => "Cancel Request -Rejected",
                    27 => "Cancelled by HR",
                );
            } else if ($max_level <= 2) {
                $dropdown_list = array(
                    1 => "Saved/Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Cancel Request- Applied",
                    15 => "Cancel Request -Level 1 Confirmed",
                    16 => "Cancel Request -Level 1 Rejected",
                    17 => "Cancel Request -Level 2 Confirmed",
                    18 => "Cancel Request -Level 2 Rejected",
                    25 => "Cancel Request -Approved",
                    26 => "Cancel Request -Rejected",
                    27 => "Cancelled by HR",
                );
            } else if ($max_level <= 3) {
                $dropdown_list = array(
                    1 => "Saved/Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    6 => "Level 3 Confirmed",
                    7 => "Level 3 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Cancel Request- Applied",
                    15 => "Cancel Request -Level 1 Confirmed",
                    16 => "Cancel Request -Level 1 Rejected",
                    17 => "Cancel Request -Level 2 Confirmed",
                    18 => "Cancel Request -Level 2 Rejected",
                    19 => "Cancel Request -Level 3 Confirmed",
                    20 => "Cancel Request -Level 3 Rejected",
                    25 => "Cancel Request -Approved",
                    26 => "Cancel Request -Rejected",
                    27 => "Cancelled by HR",
                );
            } else if ($max_level <= 4) {
                $dropdown_list = array(
                    1 => "Saved/Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    6 => "Level 3 Confirmed",
                    7 => "Level 3 Rejected",
                    8 => "Level 4 Confirmed",
                    9 => "Level 4 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Cancel Request- Applied",
                    15 => "Cancel Request -Level 1 Confirmed",
                    16 => "Cancel Request -Level 1 Rejected",
                    17 => "Cancel Request -Level 2 Confirmed",
                    18 => "Cancel Request -Level 2 Rejected",
                    19 => "Cancel Request -Level 3 Confirmed",
                    20 => "Cancel Request -Level 3 Rejected",
                    21 => "Cancel Request -Level 4 Confirmed",
                    22 => "Cancel Request -Level 4 Rejected",
                    25 => "Cancel Request -Approved",
                    26 => "Cancel Request -Rejected",
                    27 => "Cancelled by HR",
                );
            } else if ($max_level <= 5) {
                $dropdown_list = array(
                    1 => "Saved/Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    6 => "Level 3 Confirmed",
                    7 => "Level 3 Rejected",
                    8 => "Level 4 Confirmed",
                    9 => "Level 4 Rejected",
                    10 => "Level 5 Confirmed",
                    11 => "Level 5 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Cancel Request- Applied",
                    15 => "Cancel Request -Level 1 Confirmed",
                    16 => "Cancel Request -Level 1 Rejected",
                    17 => "Cancel Request -Level 2 Confirmed",
                    18 => "Cancel Request -Level 2 Rejected",
                    19 => "Cancel Request -Level 3 Confirmed",
                    20 => "Cancel Request -Level 3 Rejected",
                    21 => "Cancel Request -Level 4 Confirmed",
                    22 => "Cancel Request -Level 4 Rejected",
                    23 => "Cancel Request -Level 4 Confirmed",
                    24 => "Cancel Request -Level 4 Rejected",
                    25 => "Cancel Request -Approved",
                    26 => "Cancel Request -Rejected",
                    27 => "Cancelled by HR",
                );
            }
            echo CHtml::dropdownlist('status', 1, $dropdown_list, array('id' => 'status', 'title' => 'status', 'empty' => 'All', 'class' => 'form-control_1 col-sm-2','onchange'=>'leavehistorydetails()'));
            ?>
            <div class ="col-md-3">
                <?php echo CHtml::textField('team_fromdate', date("01/01/Y"), array('class' => 'datepicker form-control_1 startdatet', 'data-label' => 'Date')); ?>            

            </div><div class ="col-md-3" style=" position: relative;left: 15px;">
                <?php echo CHtml::textField('team_todate', date("31/12/Y"), array('class' => 'datepicker form-control_1', 'data-label' => 'Date')); ?>          
                <!--            <a href="javascript:void(0);" onclick="leavehistorydetails();" class="btn btn-warning">Load</a>-->
            </div> </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_leave_details" style="font-size:12px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Type of Leave</th>
                        <th>Apply Date</th>
                        <th>From Date</th>  
                        <th>To Date</th> 
                        <th>Days</th>     
                        <th>Half Day</th>
                        <th>AM/PM</th>
                        <th>Status</th>                                                    
                        <th>Leave Reason</th>                                                    
                        <th>LM Comment</th>                                                    
                        <th>HR Comment</th>                                                    
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
<script type="text/javascript">
    $(function () {
        $('#team_fromdate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#team_todate').data('DateTimePicker').minDate(e.date); 
            leavehistorydetails();
        })
        $('#team_todate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#team_fromdate').data('DateTimePicker').maxDate(e.date); 
            leavehistorydetails();
        })
    });
</script>

