<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("leavedetails", "function leavedetails(){
    $('#tbl_leaveapproval_history').DataTable().destroy();
        var leavetype       = $('#leavetype').val();
        var from_date       = $('#leav_fromdate').val();
        var date_from = from_date.split('/').reverse().join('-');
        var to_date       = $('#leav_todate').val();
        var date_to = to_date.split('/').reverse().join('-');
        filterDataTable(leavetype,date_from,date_to);
};", CClientScript::POS_HEAD);

$cs->registerScript("filterDataTable", 'function filterDataTable(leavetype,date_from,date_to){
        var table_id ="#tbl_leaveapproval_history";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetLeaveApprovalHistory') . '",
                type: "POST",
                "data" : {
                    "leavetype" : leavetype,
                    "date_from" : date_from,
                    "date_to" : date_to,
                    "leavestatus": $("#leave_status").val(),
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();

    }
    $(document).ready(function() {
        var leavetype= $("#leavetype").val();
        var from_date       = $("#leav_fromdate").val();
        var date_from = from_date.split("/").reverse().join("-");
        var to_date       = $("#leav_todate").val();
        var date_to = to_date.split("/").reverse().join("-");
        filterDataTable(leavetype,date_from,date_to);

    });', CClientScript::POS_HEAD);

$cs->registerScript("cancelleave", "function cancelleave(leave_id){
    jConfirm('Do you want to cancel the leave?', 'Confirmation Dialog', function(r) {
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'dataType': 'json',
                'url': '" . Yii::app()->createUrl('hr/leave/cancelleave') . "',
                'data': {'id':leave_id}  ,
                'cache': false,
                'success': function(data) {
                    if(data.status=='success'){
                        t8.success('Leave Cancelled');
                        reloadTable('#tbl_leave_details');
                    }else if(data.status=='error'){
                         t8.error('Leave cannot be cancelled as it is already approved');
                    }
                }
            });
        }
    });
}", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) { 
           let items = {};
           if (datas[10].view_button !== 0) {
               items.view = {
                   name: "View",
                   icon: "fa-eye",
                   callback: function () {
                        loadPopupModal("hr/leave/viewleavedetails&id="+datas[10].id, 'Approve/Reject Leave', "lg");
               }
               };
            }

          if (Object.keys(items).length > 0) {
              $(row).contextMenu({
                  selector: 'td',
                  items: items
              });
          }
      }

</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-sign-out"></i> -->
         Leave Approved History
        <div class="pull-right" style="display: flex;">
            <!--<label style="width: 100%">Status:</label>&nbsp;-->
            <?php
            $model_employee = User::model()->findByPk(Yii::app()->user->id);
            $employee_id = $model_employee->employee_id;
            $model_employee_detail = Employee::model()->findByPk($employee_id);
//                    $model_master = MasApproveSetting::model()->findbyPK(1);
//                    $selected=1;
//                    $dropdown_list=array(
//                        1 => "Waiting for LM Approval",
//                        6 => "Cancel Request- From Employee",
//                    );               
//            echo CHtml::dropdownlist('leave_status','',$dropdown_list, array('id' => 'leave_status', 'title' => 'leave Status', 'class' => 'form-control input-sm', 'onchange' => 'leavedetails();','empty'=>'All'));
            ?>
            <?php echo CHtml::dropdownlist('leavetype', '', MasLeave::getLeave($model_employee_detail->branch_or_sponsor_id), array('style'=>'width:250px','id' => 'leavetype', 'title' => 'leave type', 'class' => 'form-control_1', 'empty' => 'All Leaves','onchange'=>'leavedetails()')); ?>
                <div class ="col-md-3">
                <?php echo CHtml::textField('leav_fromdate', date("01/01/Y"), array('class' => 'startdatet datepicker form-control_1', 'data-label' => 'Date')); ?>            
            </div><div class ="col-md-3" style=" position: relative;left: 15px;">
                    <?php echo CHtml::textField('leav_todate', date("31/12/Y"), array('class' => 'datepicker  form-control_1', 'data-label' => 'Date')); ?>          
        </div>
                

        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_leaveapproval_history" style="font-size:12px;">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Employee</th>
                        <th>Leave Type</th>
                        <th>Apply Date</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Leaves Applied</th>
                        <th>Balance Leave</th>
                        <th>Status</th>
                        <th>Leave Reason</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
<script type="text/javascript">
    $(function () {
        $('#leav_fromdate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#leav_todate').data('DateTimePicker').minDate(e.date);  
            leavedetails();
        })
        $('#leav_todate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#leav_fromdate').data('DateTimePicker').maxDate(e.date);
            leavedetails();
        })
    });
</script>
