<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadleave", '
    function filterDataTable(employee_id,status,leavetype,branch_id,date_from,date_to) {
        var table_id ="#tbl_employeeleave_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetEmployeeLeave') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "status" : status,
                    "leavetype" : leavetype,
                    "branch_id" : branch_id,
                    "from_date" : date_from,
                    "date_to" : date_to
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	
        var employee_id       = $("#employee_id").val();
        var status  = $("#status").val();
        var leavetype        = $("#leavetype").val();	
        var branch_id       = $("#leave_branch_id").val();
      filterDataTable(employee_id,status,leavetype,branch_id);
       materializing(".material");   
    })
	', CClientScript::POS_HEAD);

$cs->registerScript("Leavedetails", "function Leavedetails(){  
    $('#tbl_employeeleave_details').DataTable().destroy();
        var employee_id       = $('#employee_id').val();
	var branch_id       = $('#leave_branch_id').val();
        var status  = $('#status').val();
        var from_date  = $('#leavein_fromdate').val();
        var date_from = from_date.split('/').reverse().join('-');
        var to_date  = $('#leavein_todate').val();
        var date_to = to_date.split('/').reverse().join('-'); 
        var leavetype        = $('#leavetype').val();
    filterDataTable(employee_id,status,leavetype,branch_id,date_from,date_to);
};", CClientScript::POS_HEAD);
$cs->registerScript("cancelwholeleave", "function cancelwholeleave(id){
    var r = confirm('Are you sure want to cancel this leave?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id='+id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/leave/cancelwholeleave',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Leave Cancelled');
                    reloadTable('#tbl_employeeleave_details'); 
                }else {
                    t8.error('Error in cancellation');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("deleteleave", "function deleteleave(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=leavemigration/deleteleave',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_employeeleave_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[9].approve_leave !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/leave/approveleave&final_level=Y&level=" + datas[9].final_leve1 + "&level=" + datas[9].level_no + "&id=" + datas[9].id, "Employee Leave", "xl");
                }
            };
        }
        if (datas[9].download_leave_document !== 0) {
            items.download = {
                name: "Download Approval Document",
                icon: "fa-download",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/leave/leaveapprovaldocument&id=" + datas[9].en_id, "_blank");
                }
            };
        }

        if (datas[9].leve_admin_approve !== 0) {
            items.adminapprove = {
                name: "Direct Approval",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/leave/approveleave&final_level=Y&level=" + datas[9].last_level + "&id=" + datas[9].id, "Employee Leave", "xl");
                }
            };
        }

        if (datas[9].leave_cancel_btn !== 0) {
            items.leavecancel = {
                name: "Leave Cancellation Request",
                icon: "fa-ban",
                callback: function () {
                    loadPopupModal("hr/leave/leavecancelbyhr&final_level=" + datas[9].cancel_final_level + "&level=" + datas[9].cancel_level_no + "&id=" + datas[9].id, "Leave Cancellation", "lg");
                }
            };
        }

        if (datas[9].edit_leave !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/leave/editapprovedleave&id=" + datas[9].id, "Employee Leave", "lg");
                }
            };
        }
        if (datas[9].cancel_leave_lock !== 0) {
            items.cancel1 = {
                name: "Cancel Leave",
                icon: "fa-trash",
                callback: function () {
                    cancelwholeleave(datas[9].id);
                }
            };
        }
        if (datas[9].cancel_leave_no_lock !== 0) {
            items.cancel2 = {
                name: "Cancel Leave",
                icon: "fa-trash",
                callback: function () {
                    cancelwholeleave(datas[9].id);
                }
            };
        }
        if (datas[9].print_leave !== 0) {
            items.print = {
                name: "Print",
                icon: "fa-file-pdf-o",
                callback: function () {
                     window.open($('#liveSite').val() + "/index.php?r=hr/leave/PrintLeavedetails&id=" + datas[9].en_id, "_blank");
                }
            };
        }
        
        if (datas[9].edit_approved_leave !== 0) {
            items.edit1 = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/leave/editapprovedleave&id=" + datas[9].id, "Employee Leave", "xl");
                }
            };
        }
        if (datas[9].cancel_leave_lock_1 !== 0) {
            items.cancel3 = {
                name: "Cancel Leave",
                icon: "fa-trash",
                callback: function () {
                    cancelwholeleave(datas[9].id);
                }
            };
        }
        if (datas[9].cancel_leave_no_lock_1 !== 0) {
            items.cancel4 = {
                name: "Cancel Leave",
                icon: "fa-trash",
                callback: function () {
                    cancelwholeleave(datas[9].id);
                }
            };
        }
        if (datas[9].leave_details_print !== 0) {
            items.print1 = {
                name: "Print",
                icon: "fa-file-pdf-o",
                callback: function () {
                     window.open($('#liveSite').val() + "/index.php?r=hr/leave/PrintLeavedetails&id=" + datas[9].en_id, "_blank");
                }
            };
        }
        if (datas[9].leave_approval_document !== 0) {
            items.printapproval = {
                name: "Download Approval Document",
                icon: "fa-download",
                callback: function () {
                     window.open($('#liveSite').val() + "/index.php?r=hr/leave/downloadDocument&frm=1&id=" + datas[9].id, "_blank");
                }
            };
        }
        
        if (datas[9].leave_view !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/leave/viewleavedetails&id=" + datas[9].id, "Employee Leave Details", "lg");
                }
            };
        }
        if (datas[9].copy_leave !== 0) {
            items.Copy = {
                name: "Copy",
                icon: "fa-copy",
                callback: function () {
                    loadPopupModal("hr/leave/copyleave&id=" + datas[9].id, "Employee Leave Details", "xl");
                }
            };
        }
        if (datas[9].hr_emp_leave_hierarchy_view !== 0) {
            items.hierarchy = {
                name: "Approval Hierarchy",
                icon: "fa-book",
                callback: function () {
                    loadPopupModal("hr/leave/approvalhierarchy&function_type=1&employee_id=" + datas[9].employee_id, "Employee Hierarchy", "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeeappraisalindexdropdown .material-select-label {
        display: none;
    }
</style>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame"> Employee Leave Details
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeappraisalindexdropdown">
                <span class="col-sm-3 pull-right">   
                    <?php echo CHtml::dropdownlist('leavetype', '', MasLeave::getParentLeave($branch), array('prompt' => 'All Leaves', 'title' => 'Leave Type', 'data-search' => true, 'onchange' => 'Leavedetails();')); ?>  &nbsp;
                </span>     

                <span class="col-sm-3 pull-right"> 
                    <?php
                    $dropdown_list = array();
                    $model_approval_status = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select' => 'max(max_level) as max_level', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and functionality_id="1"'));
                    $max_level = 0;
                    if (!empty($model_approval_status)) {
                        $max_level = $model_approval_status->max_level;
                    }
                    $selected = 'H';
                    if ($max_level <= 1) {
                        $dropdown_list = array(
                            1 => "Applied/Saved",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            12 => "Approved",
                            13 => "Rejected",
                            14 => "Cancel Request- Applied",
                            15 => "Cancel Request -Level 1 Confirmed",
                            16 => "Cancel Request -Level 1 Rejected",
                            25 => "Cancel Request -Approved",
                            26 => "Cancel Request -Rejected",
                            27 => "Cancelled by HR",
                        );
                    } else if ($max_level <= 2) {
                        $dropdown_list = array(
                            1 => "Applied/Saved",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            12 => "Approved",
                            13 => "Rejected",
                            14 => "Cancel Request- Applied",
                            15 => "Cancel Request -Level 1 Confirmed",
                            16 => "Cancel Request -Level 1 Rejected",
                            17 => "Cancel Request -Level 2 Confirmed",
                            18 => "Cancel Request -Level 2 Rejected",
                            25 => "Cancel Request -Approved",
                            26 => "Cancel Request -Rejected",
                            27 => "Cancelled by HR",
                        );
                    } else if ($max_level <= 3) {
                        $dropdown_list = array(
                            1 => "Applied/Saved",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            12 => "Approved",
                            13 => "Rejected",
                            14 => "Cancel Request- Applied",
                            15 => "Cancel Request -Level 1 Confirmed",
                            16 => "Cancel Request -Level 1 Rejected",
                            17 => "Cancel Request -Level 2 Confirmed",
                            18 => "Cancel Request -Level 2 Rejected",
                            19 => "Cancel Request -Level 3 Confirmed",
                            20 => "Cancel Request -Level 3 Rejected",
                            25 => "Cancel Request -Approved",
                            26 => "Cancel Request -Rejected",
                            27 => "Cancelled by HR",
                        );
                    } else if ($max_level <= 4) {
                        $dropdown_list = array(
                            1 => "Applied/Saved",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Confirmed",
                            9 => "Level 4 Rejected",
                            12 => "Approved",
                            13 => "Rejected",
                            14 => "Cancel Request- Applied",
                            15 => "Cancel Request -Level 1 Confirmed",
                            16 => "Cancel Request -Level 1 Rejected",
                            17 => "Cancel Request -Level 2 Confirmed",
                            18 => "Cancel Request -Level 2 Rejected",
                            19 => "Cancel Request -Level 3 Confirmed",
                            20 => "Cancel Request -Level 3 Rejected",
                            21 => "Cancel Request -Level 4 Confirmed",
                            22 => "Cancel Request -Level 4 Rejected",
                            25 => "Cancel Request -Approved",
                            26 => "Cancel Request -Rejected",
                            27 => "Cancelled by HR",
                        );
                    } else if ($max_level <= 5) {
                        $dropdown_list = array(
                            1 => "Applied/Saved",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Confirmed",
                            9 => "Level 4 Rejected",
                            10 => "Level 5 Confirmed",
                            11 => "Level 5 Rejected",
                            12 => "Approved",
                            13 => "Rejected",
                            14 => "Cancel Request- Applied",
                            15 => "Cancel Request -Level 1 Confirmed",
                            16 => "Cancel Request -Level 1 Rejected",
                            17 => "Cancel Request -Level 2 Confirmed",
                            18 => "Cancel Request -Level 2 Rejected",
                            19 => "Cancel Request -Level 3 Confirmed",
                            20 => "Cancel Request -Level 3 Rejected",
                            21 => "Cancel Request -Level 4 Confirmed",
                            22 => "Cancel Request -Level 4 Rejected",
                            23 => "Cancel Request -Level 5 Confirmed",
                            24 => "Cancel Request -Level 5 Rejected",
                            25 => "Cancel Request -Approved",
                            26 => "Cancel Request -Rejected",
                            27 => "Cancelled by HR",
                        );
                    }
                    $dropdown_list['H'] = 'Waiting For HR Approval';
                    //$dropdown_list['M']='Migrated Leave';
                    echo CHtml::dropdownlist('status', $selected, $dropdown_list, array('title' => 'Please select Status', 'data-search' => true, 'multiple' => true, 'onchange' => 'Leavedetails();'));
                    ?>
                </span>
                <span class="col-sm-3 pull-right">      
                    <?php echo CHtml::dropDownList("employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select Employee', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true, 'onchange' => 'Leavedetails();')); ?>  
                </span>
            </div>
                <div class="col-sm-3 pd-zero">     
                    <?php echo CHtml::textField('leavein_fromdate', date("01/01/Y"), array('class' => 'datepicker col-sm-2 form-control_1 startdatet', 'data-label' => 'Date')); ?>            
                </div> <div class="col-sm-3 pd-zero">         
                <?php echo CHtml::textField('leavein_todate', date("31/12/Y"), array('class' => 'datepicker col-sm-2 form-control_1', 'data-label' => 'Date')); ?>          
                </div>    
           
<!--            <div class="col-sm-1 pd-zero"> <a href="javascript:void(0);" onclick="Leavedetails();" class="btn btn-theme srch-atnd" style="height:35px;"><i class="fa fa-search" style=" line-height: 19px;"></i></a></div>-->

            <input type="hidden" id="leave_branch_id" name="leave_branch_id" value="<?php echo $branch; ?>"/>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" onclick="loadPopupModal('hr/leave/create&id=<?php echo $branch; ?>', 'Add Leave', 'xl')">
                                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employeeleave_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Apply Date</th>  
                        <th>Leave Type</th>  
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>No of Days</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
<script type="text/javascript">
    $(function () {
        $('#leavein_fromdate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#leavein_todate').data('DateTimePicker').minDate(e.date); 
            Leavedetails();
        });
        $('#leavein_todate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#leavein_fromdate').data('DateTimePicker').maxDate(e.date);  
            Leavedetails();
        });
    });
</script>
