<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'editleave-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php 
                $disabled_true=false;
                if($model->half_day_leave=='N'){
                    $disabled_true=true;
                }
                echo $form->dropDownList($model, "half_day_leave", array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Half Day Leave', 'empty' => 'Select', 'title' => 'Half Day Leave','onchange' => 'halfdayset();')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->dropDownList($model, "half_day_time", array('AM' => 'AM', 'PM' => 'PM'), array('data-label' => 'AM/PM','empty' => 'Select', 'title' => 'Half Day Leave(AM/PM)','disabled'=>$disabled_true)); ?>
            </li>
            <li class="col-sm-3">
                <?php
                $leave_start_date = '';
                if ($model->leave_start_date != '' && $model->leave_start_date != '0000-00-00') {
                    $leave_start_date = $model->leave_start_date;
                    $model->leave_start_date = date("d/m/Y", strtotime($model->leave_start_date));
                }
                echo $form->textField($model, 'leave_start_date', array('class' => 'datepicker', 'title' => 'Start Date', 'data-label' => 'Leave Start Date'));
                ?>
                <?php echo $form->error($model, 'leave_start_date'); ?>
                <?php echo $form->hiddenField($model, "employee_id"); ?>
                <?php echo $form->hiddenField($model, "id"); ?>
                <?php echo $form->hiddenField($model, "leave_type", array('value' => $model_leave->leave_type)); ?>
                <?php echo $form->hiddenField($model, "normal_leave"); ?>
                <?php echo $form->hiddenField($model, "salary_deduction_leave"); ?>
                <?php echo $form->hiddenField($model, "available_leave", array('value' => $model_leave->leave_current_balance)); ?>
                <?php echo CHtml::hiddenField("date_status", $model_setting->leave_apply_before_current_date); ?>
                <?php echo CHtml::hiddenField("negative_leave_apply_cond", $model->leavetype->negative_leave_apply_permission); ?>
                <?php
                $current_date = date('d/m/Y');
                $current_date_1 = date('Y-m-d');
                if ($model_setting->leave_apply_before_current_date == 'N') {
                    if (strtotime($current_date_1) > strtotime($leave_start_date)) {
                        $current_date = $model->leave_start_date;
                    }
                }
                echo CHtml::hiddenField("leave_current_date", $current_date);
                ?>
            </li>
            <li class="col-sm-3">
                <?php
                if ($model->leave_end_date != '' && $model->leave_end_date != '0000-00-00') {
                    $model->leave_end_date = date("d/m/Y", strtotime($model->leave_end_date));
                }
                echo $form->textField($model, 'leave_end_date', array('class' => 'datepicker', 'title' => 'Leave End Date', 'data-label' => 'Leave End Date'));
                ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'no_days', array('class' => 'tooltipster', 'title' => 'No of Days', 'data-label' => 'No Of Days', 'readonly' => true)); ?>
            </li>
            <li class="col-sm-12">
                <?php echo $form->textArea($model, 'leave_reason', array('class' => 'tooltipster', 'title' => 'Leave Reason', 'data-label' => 'Leave Reason')); ?>
            </li>
            <?php
            if ($model_master_leave->ticket_available == "Y") {
                ?>
                <li class="col-sm-2">
                <?php echo $form->dropDownList($model, "ticket_applied", array(1=> 'Yes',0 => 'No'), array('data-label' => 'Ticket', 'empty' => 'Select', 'title' => 'Apply Ticket', 'onchange' => 'checkticketapplied(this.id);')); ?>
                </li>
                <li class="col-sm-2" id="li_travel_date" style="display: none;">
                    <?php echo $form->textField($model, 'travel_date',array('class' => 'datepicker', 'title' => 'Date of Journey', 'data-label' => 'Date of Journey', 'onkeypress' => 'return false;')); ?>
                </li>
                <li class="col-sm-3" id="li_travel_destination" style="display: none;">
                    <?php echo $form->textField($model, 'travel_destination', array('class' => 'tooltipster', 'title' => 'Destination', 'data-label' => 'Destination')); ?>
                </li>
                <li class="col-sm-2" id="li_return_date" style="display: none;">
                    <?php echo $form->textField($model, 'return_date', array('class' => 'datepicker', 'title' => 'Return Date', 'data-label' => 'Return Date', 'onkeypress' => 'return false;')); ?>
                </li>
                <li class="col-sm-3" id="li_return_destination" style="display: none;">
                    <?php echo $form->textField($model, 'return_destination', array('class' => 'tooltipster', 'title' => 'Return Destination', 'data-label' => 'Return Destination')); ?>
                </li>
            <?php } ?>

            <?php
            if ($model_master_leave->document_medical_certificate_upload == "Y") {
                ?>
                <li class="col-sm-6">
                    <label class="">Upload Medical Certificate</label>
                    <?php
                    $allowedExtensions = array("csv", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif");
                    $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                        'id' => rand(),
                        'config' => array(
                            'action' => Yii::app()->createUrl('hr/' . Yii::app()->controller->id . '/UploadDocument', array('folder' => 'uploads/leavedocument')),
                            'multiple' => false,
                            'allowedExtensions' => $allowedExtensions,
                            'sizeLimit' => 6 * 1024 * 1024,
                            'onStart' => "js:function(){}",
                            'onComplete' => "js:function(id, fileName, responseJSON){
                                $('#EmployeeLeaveDetail_medical_certificate').val(responseJSON.filename); 
                                $('#li_uploaded_document').html(''); 
                           }",
                        )
                    ));
                    ?>
                    <?php echo $form->hiddenField($model, 'medical_certificate'); ?>
                </li>
                <li class="col-sm-6 pull-left" id="li_uploaded_document">
                    <?php
                    if ($model->medical_certificate != '') {
                        ?>
                        <p class="btn btn-theme"><?php echo $model->medical_certificate; ?></p> <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile(<?php echo $model->id; ?>);"><i class="fa fa-trash"></i></a>
                        <?php echo CHtml::link('<i class="fa fa-download"></i>', array('leave/downloadDocument&frm=2&id=' . $model->id), array('class' => 'btn btn-xs btn-warning', 'title' => 'Download')); ?>
                <?php }
                ?>
                </li>
    <?php }
?>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="leave_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/hr/leave/SaveAppliedLeave');
    echo CHtml::ajaxsubmitButton('Submit', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#leave_close").click();
                reloadTable("#tbl_leave_details");
            } else { 
                $.each(data, function(key, val) {
                        $("#editleave-form #"+key+"_em_").text(val).show(); 
                        t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            var no_days=$("#EmployeeLeaveDetail_no_days").val();
            if(parseFloat(no_days)<=0 || no_days==""){
                t8.error("No of days should be greater than 0");
                return false;
            }else{
                $("#loader").show();
                $(".toast8-error").hide(); 
                $("#editleave-form .editleave-save-btn").prop("disabled", true);
                $("#editleave-form .editleave-save-btn").addClass("btn_loding").removeClass("btn-theme");
              return true;
            }

        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#editleave-form .editleave-save-btn").prop("disabled", false);
            $("#editleave-form .editleave-save-btn").addClass("btn-theme").removeClass("btn_loding");
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'editleave-save-btn btn btn-theme'));
    ?>


</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("startdate", "$('#EmployeeLeaveDetail_leave_start_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
    $('#EmployeeLeaveDetail_leave_end_date').data('DateTimePicker').minDate(e.date);
    $('#EmployeeLeaveDetail_leave_end_date').addClass('filled'); 
    setleavedays();
});", CClientScript::POS_HEAD);
$cs->registerScript("enddate", "$('#EmployeeLeaveDetail_leave_end_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
    setleavedays();
});", CClientScript::POS_HEAD);
$cs->registerScript("setleavedays", "function setleavedays() {
        var start_date=$('#EmployeeLeaveDetail_leave_start_date').val();   
        var end_date=$('#EmployeeLeaveDetail_leave_end_date').val();   
        var leave_type=$('#EmployeeLeaveDetail_leave_type').val();   
        var available_leave=$('#EmployeeLeaveDetail_available_leave').val(); 
        var employee_id=$('#EmployeeLeaveDetail_employee_id').val(); 
        var chks = $('#EmployeeLeaveDetail_half_day_leave').val();
        var negative_leave=$('#negative_leave_apply_cond').val(); 
        var checkbox=0;
        if (chks=='Y'){
            checkbox=1;
        }
        if(start_date!='' && end_date!=''){
            if(parseFloat(available_leave)>0 || (parseFloat(available_leave)<=0 && negative_leave=='B')){
                jQuery.ajax({
                    'dataType':'json', 
                    'data': {'employee_id':employee_id,'available_leave':available_leave,'leave_type':leave_type,'start_date':start_date,'end_date':end_date,'checkbox':checkbox}  ,
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('hr/leave/checkleave') . "',    
                    'cache': false,
                    'success': function(data) {    
                        if(data.status=='success'){                        
                            $('#EmployeeLeaveDetail_no_days').val(data.days); 
                            $('#EmployeeLeaveDetail_no_days').addClass('filled'); 
                            $('#EmployeeLeaveDetail_normal_leave').val(data.normal_leave); 
                            $('#EmployeeLeaveDetail_salary_deduction_leave').val(data.salary_deduction_leave); 
                            $(\"input[name='half_leave']:checked\").prop('checked',false);
                        }else{
                            if(data.dateerror==1){
                                t8.error('Select Start Date');  
                            }else if(data.dateerror==2){
                                t8.error('Select End Date');  
                            }else if(data.dateerror==3){
                                $('#EmployeeLeaveDetail_leave_start_date').val(''); 
                                $('#EmployeeLeaveDetail_leave_end_date').val(''); 
                                $('#EmployeeLeaveDetail_normal_leave').val(0); 
                                $('#EmployeeLeaveDetail_salary_deduction_leave').val(0); 
                                t8.error('Leave applied in this date range');  
                            }else if(data.dateerror==4){
                                t8.error('Leaves not availabe.Maximum available leave is '+available_leave);  
                                $('#EmployeeLeaveDetail_leave_end_date').val(start_date);   
                                $('#EmployeeLeaveDetail_no_days').val(1);   
                                $('#EmployeeLeaveDetail_normal_leave').val(1); 
                                $('#EmployeeLeaveDetail_salary_deduction_leave').val(0); 
                            }else if(data.dateerror==5){
                                t8.error('Leave should be applied before '+data.applybefore);  
                                $('#EmployeeLeaveDetail_no_days').addClass('filled'); 
                                $('#EmployeeLeaveDetail_leave_start_date').val('');   
                                $('#EmployeeLeaveDetail_leave_end_date').val('');   
                                $('#EmployeeLeaveDetail_no_days').val(0);   
                                $('#EmployeeLeaveDetail_normal_leave').val(0); 
                                $('#EmployeeLeaveDetail_salary_deduction_leave').val(0); 
                            }
                        }
                    },
                    'beforeSend':function(){
                        $('.toast8-error').hide(); 
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
                });
            }else{
                if(employee_id==''){
                     t8.error('Select Employee'); 
                     $('#EmployeeLeaveDetail_leave_start_date').val('');   
                }else if(leave_type==''){
                     t8.error('Select Leave'); 
                     $('#EmployeeLeaveDetail_leave_start_date').val('');   
                }else if(available_leave<=0){
                     t8.error('No Leaves available'); 
                     $('#EmployeeLeaveDetail_leave_start_date').val('');   
                }
            }
        }
    }", CClientScript::POS_HEAD);
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    var date_disabe=$('#date_status').val();   ;
    var date_value = $('#leave_current_date').val().split('/');
    var current = new Date(date_value[2], date_value[1] - 1, date_value[0]);
    if(date_disabe=='N'){
        $('#EmployeeLeaveDetail_leave_start_date').data('DateTimePicker').minDate(current);
        $('#EmployeeLeaveDetail_leave_end_date').data('DateTimePicker').minDate(current);
    }
});", CClientScript::POS_HEAD);
$cs->registerScript("deleteuploadedfile", "function deleteuploadedfile(id) {
    jQuery.ajax({
        //'dataType':'json',
         'data': {'id':id}  ,
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/leave/deleteuploadedfile') . "',
        'cache': false,
        'success': function(data) {     
            $('#li_uploaded_document').html(''); 
        },
        'beforeSend':function(){
            $('#loader').show();
        },
        'complete':function(){
            $('#loader').hide();
        }
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("checkticketapplied ", "function checkticketapplied (){   
    var id= $('#EmployeeLeaveDetail_employee_id').val();
    var leavetype= $('#EmployeeLeaveDetail_leave_type').val();
    var startdate= $('#EmployeeLeaveDetail_leave_start_date').val();
    var enddate= $('#EmployeeLeaveDetail_leave_end_date').val();
    var ticketapply= $('#EmployeeLeaveDetail_ticket_applied').val();
    if(ticketapply==1){
        if(startdate!=''){
            jQuery.ajax({
                'dataType':'json',
                'data' : {'id':id,'leavetype':leavetype,'startdate':startdate},
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/employeetickets/checkticketencashed') . "',
                'success': function(data) {
                    if(data.status=='success'){
                        $('#li_travel_date').show();
                        $('#li_travel_destination').show();
                        $('#li_return_date').show();
                        $('#li_return_destination').show();
                        $('#EmployeeLeaveDetail_travel_date').addClass('filled');
                        $('#EmployeeLeaveDetail_travel_date').val(startdate);
                        $('#EmployeeLeaveDetail_travel_date').data('DateTimePicker').maxDate(enddate);
                        $('#EmployeeLeaveDetail_return_date').data('DateTimePicker').minDate(startdate);
                    }else{
                        $('#EmployeeLeaveDetail_ticket_applied').val(0);
                        $('#li_travel_date').hide();
                        $('#li_travel_destination').hide();
                        $('#li_return_date').hide();
                        $('#li_return_destination').hide();
                        t8.error('Ticket already encashed');
                    }
                },
                'beforeSend':function(){
                    $('#loader').show();
                },
                'complete':function(){
                    $('#loader').hide();
                }  
            });
        }else{
            $('#EmployeeLeaveDetail_ticket_applied').val(0);
            t8.error('Select Leave Date');
        }
    }else{
        $('#li_travel_date').hide();
        $('#li_travel_destination').hide();
        $('#li_return_date').hide();
        $('#li_return_destination').hide();
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("halfdayset ", "function halfdayset(){ 
    var half_day_leave= $('#EmployeeLeaveDetail_half_day_leave').val();
    if(half_day_leave=='Y'){
        $('#EmployeeLeaveDetail_half_day_time').multiselect('enable'); 
    }else{
        $('#EmployeeLeaveDetail_half_day_time').multiselect('select', '');
        $('#EmployeeLeaveDetail_half_day_time').multiselect('refresh');
        $('#EmployeeLeaveDetail_half_day_time').multiselect('disable');
    }
}", CClientScript::POS_HEAD);
?> 