<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'employeeleaveencashment-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>

                <?php
                echo $form->dropDownList($model, 'employee_id', Employee::getemployee($branch), array('empty' => 'Select', 'data-label' => 'Employee Name', 'data-search' => 'true', 'onchange' => 'masterencashmentleave(this.value);'));
                ?>
                <?php echo $form->error($model, 'employee_id');
                echo CHtml::hiddenField("salary_per_day_1");
                ?>
            </li>
            <li class="col-sm-4">
                <span id="enc_leave_1">
                    <?php
                    echo $form->dropDownList($model, 'leave_type_id', array(), array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Type'));
                    ?>
                </span>
            </li>
            <li class="col-sm-4">
                <?php
                echo CHtml::textField('emp_annual_leave', '', array('class' => 'tooltipster', 'readonly' => true, 'data-label' => 'Total Encashable leave'));
                ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'encashable_leave', array('class' => 'tooltipster', 'title' => 'Encashment Days', 'data-label' => 'Encashment Days', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateleavesalary(this.value);')); ?>
            </li>
            <li class="col-sm-4">                           
                <?php
                echo CHtml::textField('balance_leave', '', array('class' => 'tooltipster', 'title' => 'Remaining leaves', 'data-label' => 'Remaining leaves', 'readonly' => true));
                ?>
            </li>
            <li class="col-sm-4">
                <?php
                echo $form->textField($model, 'encashment_amount', array('class' => 'tooltipster', 'title' => 'Amount', 'data-label' => 'Amount', 'value' => '0.00'));
                ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="encash_leave_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/hr/leave/SaveApproveLeaveEncashment');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Details Saved Successfully!");
                                         $("#encash_leave_close").click();
                                        reloadTable("#tbl_employeeleaveenacashment_details");
                                    } else { 
                                        $("#employeeleaveencashment-form .employeeleaveencashment-save-btn").prop("disabled", false);
                                        $("#employeeleaveencashment-form .employeeleaveencashment-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) { 
                                                t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
        'beforeSend' => 'function(){
                               var encashment=$("#EmployeeLeaveEncashment_encashment_amount").val(); 
                               if(parseInt(encashment)<=0 || encashment==""){
                                    t8.error("Amount should be greater than zero");
                                    return false;
                               }else{
                                    $("#loader").show();
                                    $(".toast8-error").hide(); 
                                    $("#employeeleaveencashment-form .employeeleaveencashment-save-btn").prop("disabled", true);
                                    $("#employeeleaveencashment-form .employeeleaveencashment-save-btn").addClass("btn_loding").removeClass("btn-theme");
                                    return true;
                               }
                                
                            }',
        'complete' => 'function(){
                                $("#loader").hide();
                                $("#employeeleaveencashment-form .employeeleaveencashment-save-btn").prop("disabled", false);
                                $("#employeeleaveencashment-form .employeeleaveencashment-save-btn").addClass("btn-theme").removeClass("btn_loding");
                            }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'employeeleaveencashment-save-btn btn btn-theme'));
    ?>


</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
 $cs->registerScript("masterencashmentleave", "function masterencashmentleave(id) {
    jQuery.ajax({
              'dataType':'json',
               'data': {'id':id}  ,
               'type':'post',
               'url': '" . Yii::app()->createUrl('hr/leave/masterencashmentleave') . "',
               'cache': false,
                'success': function(data) {
                 $('#enc_leave_1').html(data.leavetype);
               }
   });
};", CClientScript::POS_HEAD);
$cs->registerScript("getleavedays", "function getleavedays() {
    var leave_type= $('#EmployeeLeaveEncashment_leave_type_id').val();
    var id= $('#EmployeeLeaveEncashment_employee_id').val();
        jQuery.ajax({
            'dataType':'json', 
            'data': {'id':id,'leave_type':leave_type}  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/leave/getencashabledays') . "',    
            'cache': false,
            'success': function(data) {    
                $('#emp_annual_leave').addClass('filled');
                $('#emp_annual_leave').val(data.leave);          
                $('#balance_leave').addClass('filled');
                $('#balance_leave').val(data.leave);
                $('#salary_per_day_1').val(data.salary_per_day);
            }
        });
};", CClientScript::POS_HEAD);
$cs->registerScript("calculateleavesalary", "function calculateleavesalary(leave_days) {
    var annual_leave = $('#emp_annual_leave').val(); 
    if(parseFloat(leave_days)<=parseFloat(annual_leave)){
        var salary_per_day = $('#salary_per_day_1').val();  
        var leave_salary =salary_per_day*leave_days;  
        var balance_leave=annual_leave-leave_days;
        $('#balance_leave').val(balance_leave.toFixed(2));  
        $('#EmployeeLeaveEncashment_encashment_amount').val(Math.round(leave_salary));  
     }else if(leave_days!=''){
        $('#EmployeeLeaveEncashment_encashable_leave').val('');  
        t8.error('Cashable leaves cannot be greater than total annual leaves');
        $('#balance_leave').val(annual_leave); 
        $('#EmployeeLeaveEncashment_encashment_amount').val('0.00'); 
        var delay=2000; //2 second

        setTimeout(function() {
        $.pnotify_remove_all(); 
        }, delay);
        
     }else{
        $('#balance_leave').val(annual_leave);
        $('#EmployeeLeaveEncashment_encashment_amount').val('0.00'); 
     }
};", CClientScript::POS_HEAD);
?>




