 <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'company-inprocess-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">  
            <li class="col-sm-6">
            <?php echo CHtml::textField('document_name',$model->documentname->document_name,array('data-label'=>'Document Name','readOnly'=>true)) ?>
            <?php echo CHtml::hiddenField('document_id',$model->document_id) ?>    
            <?php echo CHtml::hiddenField('master_doc_id',$model->id) ?>    
            </li>
            <li class="col-sm-6">  
                <?php echo $form->hiddenField($model_inprocess, 'document_id',array('value'=>$model->document_id)); ?>
                <?php echo $form->hiddenField($model_inprocess, 'id'); ?>
                <?php echo $form->dropDownList($model_inprocess,'stage_id',MasExpiryStatus::getCompanyExpiryStatus($model->document_id),array('data-label'=>'Document Type <span style="color : red;"> * </span>','prompt'=>'select','onChange'=>'getStageDate(this.value)'));?>
                <?php echo $form->error($model_inprocess, 'stage_id'); ?>
            </li>
            <?php 

            if($model_inprocess->start_date!='' && $model_inprocess->start_date!='0000-00-00'){
                    $model_inprocess->start_date =date("d/m/Y", strtotime($model_inprocess->start_date));
            }		
            if($model_inprocess->end_date!='' && $model_inprocess->end_date!='0000-00-00'){
                    $model_inprocess->end_date = date("d/m/Y", strtotime($model_inprocess->end_date));
            }
            ?>
            <li class="col-sm-6">
                <?php echo $form->textField($model_inprocess, 'start_date', array('data-label' => 'Start Date', 'class' => 'datepicker', 'title' => 'Validate till Date','onkeypress' => 'return false;')); ?>
                <?php echo $form->error($model_inprocess, 'start_date'); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->textField($model_inprocess, 'end_date', array('data-label' => 'End Date', 'class' => 'datepicker', 'title' => 'End Date','onkeypress' => 'return false;')); ?>
                <?php echo $form->error($model_inprocess, 'end_date'); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="company_inprocess_close" data-dismiss="modal">Close</button>
         <?php
         $url = Yii::app()->createUrl('inprocess/saveinprocessdocument');
               echo CHtml::ajaxSubmitButton('Save', $url, array(
                    'dataType' => 'json',
                    'type' => 'post',
                    'success' => 'function(data) {
                        if(data.status=="success"){
                            t8.success("Saved Successfully!");
                            $("#company_inprocess_close").click();
                            location.reload();                           
                         }
                        else{                       
                            $.each(data, function(key, val) {
                                t8.error(""+val+""); 
                            });                         
                         }
                    }',
                    'beforeSend' => 'function(){ 
                        $("#loader").show();
                        $(".toast8-error").hide(); 
                        $("#company-inprocess-form .companyinprocess-add-btn").prop("disabled", true);                       
                    }',
                    'complete' => 'function(){ 
                        $("#loader").hide();
                        $("#company-inprocess-form .companyinprocess-add-btn").prop("disabled", false); 
                    }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'companyinprocess-add-btn btn btn-primary'));
        ?> 	
</div>


<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getStageDate", "function getStageDate(stage_id){
    var doc_id=$('#document_id').val();
        jQuery.ajax({
            'type': 'post',
            'dataType':'json',
            'data':{'stage_id':stage_id,'doc_id':doc_id},
            'url': '" . Yii::app()->createUrl('inprocess/getStageDate') . "',
            'cache': false,
            'success': function(data)
            {
                $('#CompanyInprocessDocument_start_date').addClass('filled');
                $('#CompanyInprocessDocument_end_date').addClass('filled');
                $('#CompanyInprocessDocument_start_date').val(data.start_date);
                $('#CompanyInprocessDocument_end_date').val(data.end_date);
                $('#CompanyInprocessDocument_id').val(data.id);
            }
    
         });
  }", CClientScript::POS_HEAD);
?>










