  <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'incentive-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="incentive_item_table">
        <tr>
            <th>No</th> 
            <th>Range From</th>
            <th>Range To</th>
            <th>Percentage</th>
            <th class="text-center">
                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#incentive_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>
        <?php           
            foreach ($model_details as $i => $detail):       
        ?>
        <tr>
            <td><label><?php echo ($i+1); ?></label></td>           
            <td>
                <?php  
                echo $form->hiddenField($detail, '['.$i.']id');
                echo $form->textField($detail, "[" . $i . "]amount_from", array('class'=>'go text-right','title' => 'Amount From','onkeypress' => 'return isPositiveNumber(event)')); ?>                           
            </td>
            <td>
                <?php  echo $form->textField($detail, "[" . $i . "]amount_to", array('class'=>'go text-right ','title' => 'Amount To','onkeypress' => 'return isPositiveNumber(event)')); ?>                           
            </td>
            <td>
                <?php  echo $form->textField($detail, "[" . $i . "]percentage_val", array('class'=>'go text-right','title' => 'Percentage','onkeypress' => 'return isPositiveNumber(event)')); ?>                           
            </td>
            <td>
                <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removeincentiverow($(\'#incentive_item_table\'),this,this.id)', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="incentive_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="saveincentive()">Save</button>
</div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("saveincentive", "function saveincentive() {
   jQuery.ajax({
      'dataType':'json',
      'data' : $('#incentive-form').serialize(),
      'type':'post',
      'url': '" . Yii::app()->createUrl('hr/hrsaletarget/saveincentivemaster') . "',
      'cache': false,
      'success': function(data) {
            if(data.status=='success'){
                t8.success('Saved Successfully!');
                $('#incentive_close').click();
            }
            else{
                $.each(data, function(key, val) {
                    t8.error(''+val+'');
                });
            }

        },
        'beforeSend':function(){
            $('#loader').show();                                                                
        },
        'complete':function(){
            $('#loader').hide();                                                                
        }
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("removeincentiverow", "function removeincentiverow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#HrMasIncentiveStructure_'+arr_fields+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('hr/hrsaletarget/deletepercentage') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Deleted');
                        }else{
                            t8.error('Deletion Not Possible, History Exist');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);
?>










