<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("deleteComplaint",  "function deleteComplaint(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/hrrequest/deleteComplaint',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    reloadTable('#tbl_hr_complaint_details');
                    t8.success('Complaint Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("loadBank", '
        $(document).ready(function() {

        var table_id ="#tbl_hr_complaint_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetHrComplaintList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
       
        if (datas[5].view_complaint !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/hrrequest/ViewComplaintRequest&id=" + datas[5].id, "Complaints / Suggestions Requests ", "lg");
                }
            };
        }
        
        if (datas[5].delete_complaint !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                    deleteComplaint(datas[5].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame"> Complaints / Suggestions
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_complaint_requests_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                <a class="ad-btn" title="Add" data-toggle="modal" onclick="loadPopupModal('hr/hrrequest/createsuggestion','Add Complaint/Suggestion','lg');">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_hr_complaint_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Date</th>
                            <th>Complaint/Suggestion</th>                    
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
