<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadRequest", '
        function loadRequest() {
        var table_id ="#tbl_resignation_approval_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetResignationApproval') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    } 	$(document).ready(function() {
        loadRequest();
    });', CClientScript::POS_HEAD);
?>
<script>
     function AddContextMenu(row, datas) { 
            let items = {};
            if (datas[7].approve_button !== 0) {
                items.approve = {
                    name: "Approve",
                    icon: "fa-thumbs-up",
                    callback: function () {
                         loadPopupModal("hr/hrrequest/approveresignationlm&final_level=" + datas[7].final_level+'&level='+datas[7].level_no+'&id='+datas[7].id, 'Confirm/Reject Resignation', "lg");
                }
                };
            }
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                     loadPopupModal("hr/hrrequest/viewresignation&id=" + datas[7].id, 'Resignation Details', "lg");
            }
            }

           if (Object.keys(items).length > 0) {
               $(row).contextMenu({
                   selector: 'td',
                   items: items
               });
           }
       }
    
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-file-text"></i> -->
         Resignation Request
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_resignation_approval_details"style="font-size: 12px">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Apply Date</th>
                        <th>Last Working Day</th>
                        <th>Notice Period</th>
                        <th>Status</th>
                    </tr>
                </thead>
                
            </table>
        </div>
    </div>
</section>
