<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteRequestdetails", "function deleteRequestdetails(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'dataType'  : 'json',
              'url'  : $('#liveSite').val()+'index.php?r=hr/hrrequest/deleteRequestdetails',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Deleted SuccessFully!');
                    reloadTable('#tbl_employeecertificate_request');
                }else {
                    t8.error('Error while Delete');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs->registerScript("Requestdetails", "function Requestdetails(){  
    $('#tbl_employeecertificate_request').DataTable().destroy();
    filterDataTable();
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$cs->registerScript("loadRequestdetails", 'function filterDataTable(){
        var table_id ="#tbl_employeecertificate_request";
        var employee_id       = $("#employee_id").val();
        var status  = $("#status").val();
        var certificate        = $("#certificate").val();	
        var branch_id       = $("#certificate_branch_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
                    
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetRequestDetails') . '",
                type: "POST",
                "data" : {"employee_id" : employee_id, "status" : status,"certificate" : certificate,"certificate" : certificate,"branch_id":branch_id  },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
		
    $(document).ready(function() {  	
      filterDataTable();
       materializing(".material"); 
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[8].printvarify !== 0) {
            items.printvarify = {
                name: "Print & Verify Certificate",
                icon: "fa-file-pdf-o",
                callback: function () {
                    loadPopupModal("hr/hrrequest/printcertificate&type=1&id="+ datas[8].id, "PRINT & VERIFY CERTIFICATE", "md");
                }
            };
        }
        if (datas[8].approve_upload !== 0) {
            items.approve = {
                name: "Approve & Upload Certificate",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/Approve&final_level="+ datas[8].final_level+'&level=' + datas[8].level_no +'&id=' + datas[8].id , "APPROVE CERTIFICATE", "md");
                }
            };
        }
        if (datas[8].approve_reject !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/certificateapprove&final_level="+ datas[8].final_level+"&level=" + datas[8].level_no + "&id=" + datas[8].id , "Confirm/Reject Certificate", "lg");
                }
            };
        }
        if (datas[8].view_certificate !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/hrrequest/view&id=" + datas[8].id, "CERTIFICATE APPLICATION DETAILS", "lg");
                }
            };
        }
        if (datas[8].delete_certificate !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                    deleteRequestdetails(datas[8].id);
                }
            };
        }
        if (datas[8].admin_certificate !== 0) {
            items.admincertificate = {
                name: "Print & Verify Certificate(Direct)",
                icon: "fa-file-pdf-o",
                callback: function () {
                    loadPopupModal("hr/hrrequest/printcertificate&type=1&id="+ datas[8].id, "PRINT & VERIFY CERTIFICATE", "md");
                }
            };
        }
        if (datas[8].direct_approval !== 0) {
            items.directapproval = {
                name: "Direct Approval",
                icon: "fa-thumbs-o-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/Approve&final_level=Y&level=" + datas[8].last_level+'&id='+datas[8].id, "APPROVE CERTIFICATE", "md");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeedocumentindexdropdown .material-select-label {
        display: none;
    }
    </style>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Employee Document Request
        <div class="pull-right dis-flx rqst">
        <div class="material col-sm-12 pd-zero pull-right " id="employeedocumentindexdropdown">   
        <span class="col-sm-3 pull-right">  
            <?php echo CHtml::dropdownlist('certificate', '', MasCertificate::getCertificateName(), array('prompt' => 'Select a certificate ',  'title' => 'Certificate Name', 'data-search' => true,'onchange' => 'Requestdetails();','style'=>'width:200px;')); ?>    
         </span>
         <span class="col-sm-3 pull-right">  
           <?php
            $model_approval_status = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select' => 'max(max_level) as max_level', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and functionality_id="4"'));
            $max_level = 0;
             $selected = 'H';
            if(!empty($model_approval_status))
            {
            $max_level = $model_approval_status->max_level;
           
            if ($max_level <= 1) {
                $dropdown_list = array(
                    1 => "Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Downloaded",
                );
            } else if ($max_level <= 2) {
                $dropdown_list = array(
                    1 => "Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Downloaded",
                );
            } else if ($max_level <= 3) {
                $dropdown_list = array(
                    1 => "Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    6 => "Level 3 Confirmed",
                    7 => "Level 3 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Downloaded",
                );
            } else if ($max_level <= 4) {
                $dropdown_list = array(
                    1 => "Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    6 => "Level 3 Confirmed",
                    7 => "Level 3 Rejected",
                    8 => "Level 4 Confirmed",
                    9 => "Level 4 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Downloaded",
                );
            } else if ($max_level <= 5) {
                $dropdown_list = array(
                    1 => "Applied",
                    2 => "Level 1 Confirmed",
                    3 => "Level 1 Rejected",
                    4 => "Level 2 Confirmed",
                    5 => "Level 2 Rejected",
                    6 => "Level 3 Confirmed",
                    7 => "Level 3 Rejected",
                    8 => "Level 4 Confirmed",
                    9 => "Level 4 Rejected",
                    10 => "Level 5 Confirmed",
                    11 => "Level 5 Rejected",
                    12 => "Approved",
                    13 => "Rejected",
                    14 => "Downloaded"
                );
            }
        }
            $dropdown_list['H'] = 'Waiting For HR Approval';
            echo CHtml::dropdownlist('status', $selected, $dropdown_list, array( 'title' => 'Please Select Status', 'data-search' => true,'onchange' => 'Requestdetails();','multiple' => true,'style'=>'width:200px;'));
            ?>
            </span>
             
           
         <span class="col-sm-3 pull-right">  
            <?php echo CHtml::dropDownList("employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select Employee', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true,  'onchange' => 'Requestdetails();','style'=>'width:200px;')); ?>                           
         </span>

         </div>
            <input type="hidden" id="certificate_branch_id" name="certificate_branch_id" value="<?php echo $branch; ?>"/>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_document_request_add']) || Yii::app()->user->authorised_user == 1) { ?>
                 <a class="ad-btn" title="Add" onclick="loadPopupModal('hr/hrrequest/createrequest&branch=<?php echo $branch; ?>', 'Apply Certificate', 'xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>  
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employeecertificate_request" style="width:100%; font-size:12px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Apply Date</th>
                        <th>Approved Date</th>
                        <th>Certificate</th>  
                        <th>Apply Notes</th>  
                        <th>Status</th>                        
                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>   