<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'certificate-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->dropDownList($model, 'certificate_id',MasCertificate::getCertificateName(), array('empty' => 'Select','data-label'=>'Certificate','data-search'=>'true')); ?>
            </li>
            <li class="col-sm-3">
                <?php
                echo $form->dropDownList($model,'employee_id', Employee::getemployee($branch), array('empty' => 'Select', 'data-label' => 'Employee Name','data-search'=>'true'));
                ?>  
            </li>
            <li class="col-sm-6">
                <?php 
                $apply_notes='';
                 if($model->apply_notes!='') {
                    $apply_notes=$model->apply_notes;
                }
                echo $form->textArea($model, 'apply_notes', array('data-label'=>'Reason For Applying <span style="color : red;">*</span>','value'=>$apply_notes)); ?>
                <?php echo $form->error($model, 'apply_notes'); ?>
           </li>
        </ul>
    </div>
</div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="certificate_form_close" data-dismiss="modal">Close</button>

    	<?php
        $url = Yii::app()->createUrl('hr/hrrequest/saveCertificate');
        
        echo CHtml::ajaxsubmitButton('Apply',$url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                        t8.success("Saved Successfully!");
                                        $("#certificate_form_close").click();
                                        reloadTable("#tbl_employeecertificate_request");
                                    } else { 

                                        $("#certificate-form .save-btn").prop("disabled", false);
                                        $("#certificate-form .save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                                t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
                           'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#certificate-form .save-btn").prop("disabled", true);
                                $("#certificate-form .save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
                    ), array('id' => 'mybtn' . rand(), 'class' => 'certificate-btn btn btn-theme'));

    ?>


    </div>


<?php $this->endWidget(); ?>








