<?php
if($sort==''){
    $sort=1;
}
?>
<div class="out_border">
    <div class="row">
        <div class="col-md-12">
             <ul class="clearfix form-ul material"> 
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_location_branch_id',$branch_id,MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch','empty'=>'All','data-search'=>true,'onchange'=>'getbranchemployee();'));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_emp_location_status_val',$status,array('Y' => 'Active Employees', 'B' => 'Blocked Employees'),array('data-label'=>'Employee Status','empty'=>'All Employees','onchange'=>'getbranchemployee();'));?>
                    </div>
                </li>
                 <li class="col-sm-3">
                    <div class="material" id='li_location_employee_id'>    
                        <?php echo CHtml::dropDownList('_location_employee_id',$employee_id,Employee::getEmployeedetails($branch_id,$status),array('data-label'=>'Employee','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                <li class="col-sm-3">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_location_department_id',$department_id,MasDepartment::getDepartment(),array('data-label'=>'Department','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_location_designation_id',$designation_id,MasDesignation::getDesignation(),array('data-label'=>'Designation','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_location_nationality',$nationality_id,Employee::getNationality(),array('data-label'=>'Nationality','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_location_id',$location_id,HrMasWorkLocation::getLocation(),array('data-label'=>'Work Location','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_location_year',$year,HrGenerelSettings::listYears(10,1),array('data-label'=>'Year','data-search'=>true));?>
                        <?php echo CHtml::HiddenField('_location_year_old',$year);?>
                        <?php echo CHtml::HiddenField('_reset_2_year_old',$reset_year);?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_sort_order_location',$sort,array(1 =>'Work Location', 2 => 'Employee'),array('data-label'=>'Sort By'));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <button type="button" onclick="loadlocationlist();return false;" class='btn btn-theme'>Load</button>
                    <button type="button" onclick="resetfilters();return false;" class='btn btn-warning'>Reset</button>
                    <button type="button" class="btn btn-danger " id="<?php echo rand();?>" data-dismiss="modal">Back</button>
                </li>
             </ul>
        </div>
        <div class="col-md-12">
            <div class="col-lg-12"><div class="title text-center text-bold">WORK LOCATION</div><div id="chart_loc_div"></div></div>
        </div>
        <div class="col-md-12" id="div_employee_location_list">
            <div class="personal_dett clearfix form-ul material">
                <?php
                $start_date=$year.'-01-01';
                $end_date=$year.'-12-31';
                $condition='t.date_join<="'.$end_date.'" AND (t.date_blocked="0000-00-00" OR (t.date_blocked>="'.$start_date.'" AND t.date_blocked<="'.$end_date.'"))';
                if($location_id>0){
                    $condition.=' AND work_location_id="'.$location_id.'"';
                }
                if ($status=='Y') {
                    $condition.= ' AND t.isActive!= "B"';
                }else if ($status=='B') {
                    $condition.= ' AND t.isActive= "B"';
                }
                if ($branch_id>0) {
                    $condition.= ' AND t.branch_or_sponsor_id= "'.$branch_id.'"';
                }
                if ($employee_id>0) {
                    $condition.= ' AND t.id= "'.$employee_id.'"';
                }
                if ($department_id > 0) {
                    $condition .= ' AND t.department = "' . $department_id . '"';
                }
                if ($designation_id > 0) {
                    $condition .= ' AND t.designation = "' . $designation_id . '"';
                }
                if ($nationality_id > 0) {
                    $condition .= ' AND t.nationality = "' . $nationality_id . '"';
                }
                $chartData_location='';
                $arr_gender=array(1=>'Male',2=>'Female');
                $arr_type=array('S'=>'Skilled','U'=>'Unskilled');
                //Country
                $model_mas_location = Employee::model()->with('location')->findAll(array('condition' =>$condition,'group'=>'t.work_location_id','order' => 'location.location_name ASC'));
                foreach ($model_mas_location as $key_11 => $value_1) {
                    $lc_condition_1=$condition.' AND t.work_location_id="'.$value_1->work_location_id.'"';
                    $_location_count = Employee::model()->count(array('condition' =>$lc_condition_1));
                    $chartData_location.='{"location": "'.$value_1->location->location_name.'","count": "'.$_location_count.'","id": "'.$value_1->work_location_id.'"},';
                }
                $model_employee = Employee::model()->with('location')->findAll(array('condition' =>$condition));
                if(!empty($model_employee)){
                    ?>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered personal-task" style="font-size:12px;">
                        <tr style="background-color: #005aa6; color: white">   
                            <th style="width: 3%" class="text-center">No</th>
                            <th style="width: 5%" class="text-center">Code</th>
                            <th style="width: 30%" class="text-center">Name</th>
                            <th style="width: 10%" class="text-center">Work Location</th>
                            <th style="width: 4%" class="text-center">Type</th>
                            <th style="width: 4%" class="text-center">Gender</th>  
                            <th style="width: 10%" class="text-center">Department</th>
                            <th style="width: 10%" class="text-center">Designation</th>
                            <th style="width: 10%" class="text-center">Nationality</th>
                            <th style="width: 5%" class="text-center">Salary</th>
                            <th style="width: 7%" class="text-center">Date of Join</th>
                            <th style="width: 6%" class="text-center">Visa Entity</th>
                            <th style="width: 8%" class="text-center">Contract Start</th>
                            <th style="width: 7%" class="text-center">Contract End</th>
                        </tr>
                    <?php
                    $arr_employee = array();
                    foreach ($model_employee as $key => $value) {
                        $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
                    }
                    ksort($arr_employee); 
                    if(!empty($arr_employee)){
                         $g=1;
                        foreach ($arr_employee as $emp_id) {
                            $model_employee= Employee::model()->findbyPK($emp_id);
                            $model_salary_details = EmployeeSalary::model()->find(array('select'=>'sum(amount) as amount','condition'=>'employee_id="'.$model_employee->id.'" AND valid_to="0000-00-00" AND isActive="Y"'));
                            $salary_amount=0.00;
                            if(!empty($model_salary_details) && $model_salary_details->amount>0){
                                $salary_amount=$model_salary_details->amount;
                            }
                            $joining_date=$last_eos_date=$contract_end="";
                            if($model_employee->date_join!='' && $model_employee->date_join!='0000-00-00'){
                                $joining_date=date("d/m/Y",strtotime($model_employee->date_join));
                            }
                            if($model_employee->last_eos_date!='' && $model_employee->last_eos_date!='0000-00-00'){
                                $last_eos_date=date("d/m/Y",strtotime($model_employee->last_eos_date));
                            }
                            //Contract ENd
                            $model_contract_end = EmployeeDocuments::model()->find(array('select'=>'validate_till_date','condition'=>'employee_id="'.$model_employee->id.'" AND document_id="17"'));
                            if(!empty($model_contract_end) && $model_contract_end->validate_till_date!='' && $model_contract_end->validate_till_date!='0000-00-00'){
                                $contract_end=date("d/m/Y",strtotime($model_contract_end->validate_till_date));
                            }
                            if($model_employee->isActive=='B'){
                                $contract_end=date("d/m/Y",strtotime($model_employee->date_blocked));
                            }
                            //WPS
                            $wps_company='';
                            $model_wps_company = EmployeewpsCompany::model()->find(array('condition'=>'employee_id="'.$model_employee->id.'"'));
                            if(!empty($model_wps_company)){
                                $wps_company=$model_wps_company->companydetail->company_name;
                            }
                        ?>
                            <tr>
                                <td><?php echo $g; ?></td>
                                <td><?php echo $model_employee->employeecode; ?></td>
                                <td><?php echo $model_employee->employeefullname; ?></td>
                                <td><?php echo $model_employee->location->location_name; ?></td>
                                <td><?php echo $arr_type[$model_employee->worker_type]; ?></td>
                                <td><?php echo $arr_gender[$model_employee->gender]; ?></td>
                                <td><?php echo $model_employee->departmentdetail->department_name; ?></td>
                                <td><?php echo $model_employee->designationdetail->designation_name; ?></td>
                                <td><?php echo $model_employee->employeenationality->country_name; ?></td>
                                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($salary_amount, " "); ?></td>
                                <td class="text-center"><?php echo $joining_date; ?></td>
                                <td><?php echo $wps_company; ?></td>
                                <td class="text-center"><?php echo $last_eos_date; ?></td>
                                <td class="text-center"><?php echo $contract_end; ?></td>
                            </tr>
                            <?php
                            $g++;
                        }
                    }
                }else{
                    ?>
                            <tr><td colspan="7">No Data Available</td></tr>
                    <?php
                }
                ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger " id="<?php echo rand();?>" data-dismiss="modal">Close</button>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getbranchemployee", "function getbranchemployee(){  
    var branch     = $('#_location_branch_id').val();
    var status     = $('#_emp_location_status_val').val();
        jQuery.ajax({
           'dataType':'json',
            'data' : {'field':'_location_employee_id','branch':branch,'status':status},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/hrrepresentation/getbranchemployee') . "',
            'success': function(data) {
                $('#li_location_employee_id').html(data.employee);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);
$cs->registerScript("loadlocationlist",  "function loadlocationlist(){ 
    var branch_id   = $('#_location_branch_id').val();
    var employee_id   = $('#_location_employee_id').val();
    var location_id   = $('#_location_id').val();
    var status     = $('#_emp_location_status_val').val();
    var sort_order     = $('#_sort_order_location').val();
    var department   = $('#_location_department_id').val();
    var designation   = $('#_location_designation_id').val();
    var nationality   = $('#_location_nationality').val();
    var year     = $('#_location_year').val();
    var r_year     = $('#_reset_2_year_old').val();
    loadPopupModal('hr/hrrepresentation/worklocationlist&department='+department+'&designation='+designation+'&nationality='+nationality+'&branch_id='+branch_id+'&employee_id='+employee_id+'&location_id='+location_id+'&status='+status+'&sort_order='+sort_order+'&year='+year+'&r_year='+r_year,'Work Location','xl');
};", CClientScript::POS_HEAD);
$cs->registerScript("filterlocationlist",  "function filterlocationlist(){ 
    var branch_id   = $('#_location_branch_id').val();
    var employee_id   = $('#_location_employee_id').val();
    var location_id   = $('#_location_id').val();
    var status     = $('#_emp_location_status_val').val();
    var sort_order     = $('#_sort_order_location').val();
    var department   = $('#_location_department_id').val();
    var designation   = $('#_location_designation_id').val();
    var nationality   = $('#_location_nationality').val();
    var year     = $('#_location_year').val();
    jQuery.ajax({
        'type':'post',
        'data':'department='+department+'&designation='+designation+'&nationality='+nationality+'&branch_id='+branch_id+'&employee_id='+employee_id+'&location_id='+location_id+'&year='+year+'&status='+status+'&sort_order='+sort_order,
        'url': '" . Yii::app()->createUrl('hr/hrrepresentation/filterlocationlist') . "',
        'cache': false,
        'success': function(data) {
            $('#div_employee_location_list').html(data);
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        }
   });
};", CClientScript::POS_HEAD);
$cs->registerScript("resetfilters", " function resetfilters() {
    $('#_location_department_id').multiselect('select', '');
    $('#_location_department_id').multiselect('refresh');
    $('#_location_designation_id').multiselect('select', '');
    $('#_location_designation_id').multiselect('refresh');
    $('#_location_nationality').multiselect('select', '');
    $('#_location_nationality').multiselect('refresh');
    $('#_location_employee_id').multiselect('select', '');
    $('#_location_employee_id').multiselect('refresh');
    $('#_location_id').multiselect('select', '');
    $('#_location_id').multiselect('refresh');
    $('#_location_branch_id').multiselect('select', '');
    $('#_location_branch_id').multiselect('refresh');
    $('#_emp_location_status_val').multiselect('select', 'Y');
    $('#_emp_location_status_val').multiselect('refresh');
    var r_year     = $('#_reset_2_year_old').val();
    $('#_location_year').multiselect('select',r_year);
    $('#_location_year').multiselect('refresh');
    $('#_location_year_old').val(r_year);
    loadlocationlist();
} ", CClientScript::POS_HEAD);
?>
<style>
#chart_loc_div {
  width: 100%;
  height: 400px;
}
</style>
<script>
am4core.ready(function() {

// Themes begin
am4core.useTheme(am4themes_kelly);
// Themes end

var chart = am4core.create("chart_loc_div", am4charts.PieChart3D);
chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chart.legend = new am4charts.Legend();
chart.data = [<?php echo $chartData_location; ?>];

var series = chart.series.push(new am4charts.PieSeries3D());
series.dataFields.value = "count";
series.dataFields.category = "location";
series.dataFields.id = "id";
series.legendSettings.labelText = "{category}: {value.percent.formatNumber('#.0')}%";
chart.legend.valueLabels.template.text = "{value.value}";
series.labels.template.radius = am4core.percent(5);
series.labels.template.fill = am4core.color("black");
series.labels.template.fontSize = 11;
series.labels.template.paddingTop = 0;
series.labels.template.paddingBottom = 0;
series.slices.template.events.on("hit", function(ev){
  var location=ev.target.dataItem.id;
  var location_id= $('#_location_id').val();
  if(location==location_id){
      location='';
  }
  $('#_location_id').multiselect('select', location);
  $('#_location_id').multiselect('refresh');
  var series = ev.target.dataItem.component;
  series.slices.each(function(item) {
    if (item.isActive && item != ev.target) {
      item.isActive = false;
    }
  })
  filterlocationlist();
});
chart.legend.valueLabels.template.disabled = true;
chart.legend.fontSize= 11;
chart.legend.fontWeight="bold";
chart.legend.maxHeight = 100;
chart.legend.scrollable = true;
chart.legend.itemContainers.template.paddingTop = 2;
chart.legend.itemContainers.template.paddingBottom = 2;
}); // end am4core.ready()
</script>