<?php
if($sort==''){
    $sort=1;
}
?>
<div class="out_border">
    <div class="row">
        <div class="col-md-12">
             <ul class="clearfix form-ul material"> 
                <li class="col-sm-1">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_allowance_branch_id',$branch_id,MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch','empty'=>'All','data-search'=>true,'onchange'=>'getsalesperson();'));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_allowance_status_val',$status,array('Y' => 'Active Sales Person', 'B' => 'Blocked Sales Person'),array('data-label'=>'Sales Person Status','empty'=>'All Status','onchange'=>'getsalesperson();'));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material" id='li_allowable_employee_id'>    
                        <?php echo CHtml::dropDownList('_allowance_employee_id',$employee_id,User::getemployeeconnectedsalesperson($branch_id,$status),array('data-label'=>'Sales Person','data-search'=>true,'empty'=>'All Sales Person'));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_allowance_month',$month,HrGenerelSettings::listMonths(),array('data-label'=>'Month'));?>
                    </div>
                </li>
                <li class="col-sm-1">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_allowance_year',$year,HrGenerelSettings::listYears(5,1),array('data-label'=>'Year',));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_allowance_sort_order',$sort,array(1=> 'Sales Person',2=> 'Employee'),array('data-label'=>'Sort Order'));?>
                        <?php echo CHtml::HiddenField('salary_type_id');?>
                        <?php echo CHtml::HiddenField('salary_type_id_value');?>
                        <?php echo CHtml::HiddenField('_reset_7_year_old',$reset_year);?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <button type="button" onclick="loadmonthlypayablelist();return false;" class='btn btn-theme'>Load</button>
                    <button type="button" onclick="resetfilters();return false;" class='btn btn-warning'>Reset</button>
                    <button type="button" class="btn btn-danger " id="<?php echo rand();?>" data-dismiss="modal">Back</button>
                </li>
             </ul>
        </div>
        <div class="col-md-12">
            <div class="col-lg-12"><div class="title text-center text-bold">ALLOWANCE PAID</div><div id="chartdiv_allowance_salesperson"></div></div>
            <div class="col-lg-12"><div class="title text-center text-bold">TOTAl ALLOWANCE PAID</div><div id="chart_allowance_pie"></div></div>
        </div>
        <div class="col-md-12">
            <div class="personal_dett clearfix form-ul material" id="div_allowance_change">
                <div class="table-responsive">
                    <table class="table table-hover table-bordered personal-task" style="font-size:13px;">
                        <tr style="background-color: #005aa6; color: white">   
                            <th style="width: 5%" class="text-center">No</th>
                            <th style="width: 9%" class="text-center">Code</th>
                            <th style="width: 30%" class="text-center">Employee Name</th>
                            <th style="width: 14%" class="text-center">Amount</th>
                        </tr>
                        <?php
                        $condition='t.is_lead_owner="Y" AND t.company_id="' . Yii::app()->user->master_user_company_id.'" AND connected_employee_id>0';
                        if ($branch_id>0) {
                            $condition.= ' AND connectedemployee.branch_or_sponsor_id= "'.$branch_id.'"';
                        }
                        if ($status=='Y') {
                            $condition.= ' AND connectedemployee.isActive!= "B"';
                        }else if ($status=='B') {
                            $condition.= ' AND connectedemployee.isActive= "B"';
                        }
                        if ($employee_id>0) {
                            $condition.= ' AND t.connected_employee_id= "'.$employee_id.'"';
                        }
                        $chartData=$chartData_pie='';
                        $h=$v=0;
                        $arr_emp=array();
                        $model_lead_owner = User::model()->with('connectedemployee')->findAll(array('condition' => $condition,'order'=>'t.first_name asc'));
                        if (!empty($model_lead_owner)) {
                            $g=1;
                            $grand_total=0.00;
                            $model_master_details = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_type="1" AND salary_occurence="1"','order'=>'sort_order'));
                            //Graph Data
                            foreach ($model_master_details as $k => $detail):
                                $allowance_amt=0.00;
                                foreach ($model_lead_owner as $key => $value) {
                                    $model_amount_details = SalarySlipDetails::model()->with('processingdetail','slipdetail','salarytype')->find(array('condition' => 'slipdetail.employee_id="'.$value->connected_employee_id.'" AND processingdetail.payroll_startdate>="' . $start_date . '" AND processingdetail.payroll_enddate<="' . $end_date . '" and t.salary_id="' . $detail->id . '"'));                            
                                    if($model_amount_details->salary_amount>0){
                                        $allowance_amt+=$model_amount_details->salary_amount;
                                    }
                                    
                                }
                                if($allowance_amt>0){
                                    $chartData_pie.='{"salary_type":"'.$detail->salary_name.'","amount":'.$allowance_amt.',"id": "'.$detail->id.'","id_value": ""},';
                                }
                            endforeach;
                            $total_ot=$total_sanct_loan=$total_reward=0.00;
                            foreach ($model_lead_owner as $key => $value) {
                                $model_employee = Employee::model()->findbyPK($value->connected_employee_id);
                                $model_salary_slip = SalarySlip::model()->with('processing')->find(array('condition'=>'employee_id="'.$value->connected_employee_id.'" AND processing.payroll_startdate>="' . $start_date . '" AND processing.payroll_enddate<="' . $end_date . '"'));
                                //Additions
                                $additions=0.00;
                                $model_addition_amount = SalarySlipDetails::model()->with('processingdetail','slipdetail','salarytype')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' => 'slipdetail.employee_id="'.$value->connected_employee_id.'" AND processingdetail.payroll_startdate>="' . $start_date . '" AND processingdetail.payroll_enddate<="' . $end_date . '" and salarytype.salary_type="1" and salarytype.salary_occurence="1"'));
                                if($model_addition_amount->salary_amount>0){
                                    $additions+=$model_addition_amount->salary_amount;
                                }
                                //Overtime
                                if($model_salary_slip->overtime_amount>0){
                                    $additions+=$model_salary_slip->overtime_amount;
                                    $total_ot+=$model_salary_slip->overtime_amount;
                                }
                                //Loan Paid
                                if($model_salary_slip->sanctioned_loan_amount>0){
                                    $additions+=$model_salary_slip->sanctioned_loan_amount;
                                    $total_sanct_loan+=$model_salary_slip->sanctioned_loan_amount;
                                }
                                //Other Addition/Reward
                                if($model_salary_slip->other_addition>0){
                                    $additions+=$model_salary_slip->other_addition;
                                    $total_reward+=$model_salary_slip->other_addition;
                                }
                                $employee_total_addition=0.00;
                                if($additions>0){
                                ?>
                                    <tr id="parent_<?php echo $g; ?>" style="border-top: 2px solid #2440bf;">
                                        <td><label><?php echo ($g); ?></label></td> 
                                        <td><?php echo $model_employee->employeecode; ?></td>
                                        <td><?php echo $model_employee->employeefullname; ?></td>
                                        <td></td>
                                    </tr>
                                    <tr id="child_<?php echo $v; ?>">
                                        <?php
                                        foreach ($model_master_details as $k => $detail):
                                            $model_addition_amount_details = SalarySlipDetails::model()->with('processingdetail','slipdetail','salarytype')->find(array('condition' => 'slipdetail.employee_id="'.$value->connected_employee_id.'" AND processingdetail.payroll_startdate>="' . $start_date . '" AND processingdetail.payroll_enddate<="' . $end_date . '" and t.salary_id="' . $detail->id . '"'));
                                            if($model_addition_amount_details->salary_amount>0){
                                                $arr_emp[$h]=$detail->salary_name;
                                                $chartData.='{"fullname": "'.$model_employee->employeefullname.'","employee": "'.$model_employee->alias.'","'.$detail->salary_name.'": '.$model_addition_amount_details->salary_amount.'},';
                                                $employee_total_addition+=$model_addition_amount_details->salary_amount;
                                                $grand_total+=$model_addition_amount_details->salary_amount;
                                                ?>
                                                <tr style="font-style: italic" class="">
                                                    <td colspan="3" class="text-right"><?php  echo $detail->salary_name; ?></td>
                                                    <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_addition_amount_details->salary_amount,""); ?></td>
                                                </tr>
                                            <?php
                                            }
                                        endforeach;
                                if($model_salary_slip->overtime_amount>0){
                                    $employee_total_addition+=$model_salary_slip->overtime_amount;
                                    $grand_total+=$model_salary_slip->overtime_amount;
                                    $arr_emp[$h]="Overtime";
                                    $chartData.='{"fullname": "'.$model_employee->employeefullname.'","employee": "'.$model_employee->alias.'","Overtime": '.$model_salary_slip->overtime_amount.'},';
                                    ?>
                                    <tr style="font-style: italic" class="">
                                        <td colspan="3" class="text-right">Overtime</td>
                                        <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_salary_slip->overtime_amount,""); ?></td>
                                    </tr>
                                    <?php
                                }
                                if($model_salary_slip->sanctioned_loan_amount>0){
                                    $arr_emp[$h]="Loan Paid";
                                    $employee_total_addition+=$model_salary_slip->sanctioned_loan_amount;
                                    $grand_total+=$model_salary_slip->sanctioned_loan_amount;
                                    $chartData.='{"fullname": "'.$model_employee->employeefullname.'","employee": "'.$model_employee->alias.'","Loan Paid": '.$model_salary_slip->sanctioned_loan_amount.'},';
                                    ?>
                                    <tr style="font-style: italic" class="">
                                        <td colspan="3" class="text-right">Loan Paid</td>
                                        <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_salary_slip->sanctioned_loan_amount,""); ?></td>
                                    </tr>
                                    <?php
                                }
                                if($model_salary_slip->other_addition>0){
                                    $arr_emp[$h]="Reward";
                                    $employee_total_addition+=$model_salary_slip->other_addition;
                                    $grand_total+=$model_salary_slip->other_addition;
                                    $chartData.='{"fullname": "'.$model_employee->employeefullname.'","employee": "'.$model_employee->alias.'","Reward": '.$model_salary_slip->other_addition.'},';
                                    ?>
                                    <tr style="font-style: italic" class="">
                                        <td colspan="3" class="text-right">Reward</td>
                                        <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($model_salary_slip->other_addition,""); ?></td>
                                    </tr>
                                    <?php
                                }
                                $v++;
                                ?>
                                </tr>
                                <tr style="font-style: italic;" class="text-bold bg-warning">
                                    <td colspan="3" class="text-right">Gross Amount</td>
                                    <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($employee_total_addition,""); ?></td>
                                </tr>
                                <?php
                                $g++;
                                $h++;
                                }
                            }
                            if($total_ot>0){
                                $chartData_pie.='{"salary_type":"Overtime","amount":'.$total_ot.',"id": "","id_value": "OT"},';
                            }
                            if($total_sanct_loan>0){
                                $chartData_pie.='{"salary_type":"Loan Paid","amount":'.$total_sanct_loan.',"id": "","id_value": "LP"},';
                            }
                            if($total_reward>0){
                                $chartData_pie.='{"salary_type":"Reward","amount":'.$total_reward.',"id": "","id_value": "RD"},';
                            }
                            ?>
                            <tr style="font-style: italic; border-top: 2px solid #2440bf; color: red;" class="text-bold bg-success">
                                <td colspan="3" class="text-right">Grand Total</td>
                                <td class="text-right"><?php  echo Yii::app()->numberFormatter->formatCurrency($grand_total,""); ?></td>
                            </tr>
                            <?php
                        } 
                        ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="employee_close" data-dismiss="modal">Close</button>
</div>
<?php
$arr_emp=array_unique($arr_emp);
$cs = Yii::app()->getClientScript();
$cs->registerScript("getsalesperson", "function getsalesperson(){  
    var branch     = $('#_allowance_branch_id').val();
    var status     = $('#_allowance_status_val').val();
        jQuery.ajax({
           'dataType':'json',
            'data' : {'field':'_allowance_employee_id','branch':branch,'status':status},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/hrrepresentation/getsalesperson') . "',
            'success': function(data) {
                $('#li_allowable_employee_id').html(data.employee);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);
$cs->registerScript("loadmonthlypayablelist", "function loadmonthlypayablelist(){  
    var branch_id   = $('#_allowance_branch_id').val();
    var status     = $('#_allowance_status_val').val();
    var employee_id   = $('#_allowance_employee_id').val();
    var allowance_month   = $('#_allowance_month').val();
    var allowance_year   = $('#_allowance_year').val();
    var sort_order     = $('#_allowance_sort_order').val();
    var r_year     = $('#_reset_7_year_old').val();
    loadPopupModal('hr/hrrepresentation/allowancechanges&branch_id='+branch_id+'&employee_id='+employee_id+'&allowance_month='+allowance_month+'&allowance_year='+allowance_year+'&status='+status+'&sort_order='+sort_order+'&r_year='+r_year,'Allowance Changes','xl');   
};", CClientScript::POS_HEAD);
$cs->registerScript("filterallowancechange", " function filterallowancechange() {
    var branch_id   = $('#_allowance_branch_id').val();
    var status     = $('#_allowance_status_val').val();
    var employee_id   = $('#_allowance_employee_id').val();
    var allowance_month   = $('#_allowance_month').val();
    var allowance_year   = $('#_allowance_year').val();
    var sort_order     = $('#_allowance_sort_order').val();
    var salary_id   = $('#salary_type_id').val();
    var salary_value   = $('#salary_type_id_value').val();
    jQuery.ajax({
        'type':'post',
        'data':'branch_id='+branch_id+'&employee_id='+employee_id+'&allowance_month='+allowance_month+'&allowance_year='+allowance_year+'&status='+status+'&sort_order='+sort_order+'&salary_id='+salary_id+'&salary_value='+salary_value,
        'url': '" . Yii::app()->createUrl('hr/hrrepresentation/filterallowancechange') . "',
        'cache': false,
        'success': function(data) {
            $('#div_allowance_change').html(data);
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        }
   });
} ", CClientScript::POS_HEAD);
$cs->registerScript("resetfilters", "function resetfilters() {
    $('#_allowance_branch_id').multiselect('select', '');
    $('#_allowance_branch_id').multiselect('refresh');
    $('#_allowance_status_val').multiselect('select', 'Y');
    $('#_allowance_status_val').multiselect('refresh');
    $('#_allowance_employee_id').multiselect('select', '');
    $('#_allowance_employee_id').multiselect('refresh');
    $('#_allowance_month').multiselect('select', '');
    $('#_allowance_month').multiselect('refresh');
    var r_year     = $('#_reset_7_year_old').val();
    $('#_allowance_year').multiselect('select',r_year);
    $('#_allowance_year').multiselect('refresh');
    $('#salary_type_id').val('');
    $('#salary_type_id_value').val('');
    loadmonthlypayablelist();
} ", CClientScript::POS_HEAD);
?>
<style>
#chartdiv_allowance_salesperson {
  width: 100%;
  height: 500px;
}
#chart_allowance_pie {
  width: 100%;
  height: 400px;
}
</style>
<script>
am4core.ready(function() {
am4core.useTheme(am4themes_animated);
var chart = am4core.create("chartdiv_allowance_salesperson", am4charts.XYChart);
chart.data = [<?php echo $chartData; ?>];
// Create axes
var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
categoryAxis.dataFields.category = "employee";
categoryAxis.title.text = "[bold]Salary Component";
categoryAxis.renderer.grid.template.location = 0;
categoryAxis.renderer.minGridDistance = 20;
categoryAxis.renderer.cellStartLocation = 0.1;
categoryAxis.renderer.cellEndLocation = 0.9;
categoryAxis.renderer.inversed = true;
var  valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
//valueAxis.min = 0;
valueAxis.title.text = "Amount";
// Create series
function createSeries(field, name, stacked) {
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.valueY = field;
    series.dataFields.categoryX = "employee";
    series.name = name;
    series.dataFields.amount = "amount";
    series.dataFields.fullname = "fullname";
    series.dataFields.amount = "amount";
    series.columns.template.tooltipText = "{name} : [bold]{valueY}[/]";
    series.stacked = stacked;
    series.columns.template.width = am4core.percent(40);
}
<?php
foreach ($arr_emp as $value) {
?>
createSeries("<?php echo $value; ?>","<?php echo $value; ?>",false);
<?php } ?>
chart.legend = new am4charts.Legend();
chart.legend.itemContainers.template.clickable = false;
chart.legend.itemContainers.template.focusable = false;
// Pie chart
am4core.useTheme(am4themes_kelly);
// Themes end

var chart = am4core.create("chart_allowance_pie", am4charts.PieChart3D);
chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chart.legend = new am4charts.Legend();
chart.data = [<?php echo $chartData_pie; ?>];

var series = chart.series.push(new am4charts.PieSeries3D());
series.dataFields.value = "amount";
series.dataFields.category = "salary_type";
series.dataFields.salary_id = "id";
series.dataFields.salary_code = "id_value";
series.legendSettings.labelText = "{category}: {value.percent.formatNumber('#.0')}%";
chart.legend.valueLabels.template.text = "{value.value}";
series.labels.template.radius = am4core.percent(5);
series.labels.template.fill = am4core.color("black");
series.labels.template.fontSize = 11;
series.labels.template.paddingTop = 0;
series.labels.template.paddingBottom = 0;
series.slices.template.events.on("hit", function(ev){
  var salary_type_id=ev.target.dataItem.salary_id;
  var salary_type_id_value=ev.target.dataItem.salary_code;
  var salary_id   = $('#salary_type_id').val();
  var salary_value   = $('#salary_type_id_value').val();
  if(salary_type_id==salary_id){
      salary_type_id='';
  }
  if(salary_type_id_value==salary_value){
      salary_type_id_value='';
  }
  $('#salary_type_id').val(salary_type_id);
  $('#salary_type_id_value').val(salary_type_id_value);
  var series = ev.target.dataItem.component;
  series.slices.each(function(item) {
    if (item.isActive && item != ev.target) {
      item.isActive = false;
    }
  })
  var salary_id   = $('#salary_type_id').val();
  var salary_value   = $('#salary_type_id_value').val();
    if(salary_id=='' && salary_value==''){
        loadmonthlypayablelist();
    }else{
        filterallowancechange();
    }
});
chart.legend.valueLabels.template.disabled = true;
chart.legend.position = "right";
chart.legend.valign = "top";
chart.legend.fontSize= 12;
chart.legend.fontWeight="bold";
//chart.legend.maxHeight = 100;
//chart.legend.scrollable = true;
chart.legend.itemContainers.template.clickable = false;
chart.legend.itemContainers.template.focusable = false;
});
</script>
