<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Expense Report
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table  class="table table-fixed table-bordered table-primary dataTable html_table">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw">No</th>
                        <th class="text-center tbl-iw nw">ID #</th>
                        <th class="text-center tbl-iw nw">Branch</th>
                        <th class="text-center tbl-iw nw">Emp.Code</th>                    
                        <th class="text-center tbl-iw nw">Employee Name</th>        
                        <th class="text-center tbl-iw nw">Apply Date</th>     
                        <th class="text-center tbl-iw nw">Approve Date</th>  
                        <th class="text-center tbl-iw nw">Payment Mode</th>  
                        <th class="text-center tbl-iw nw">Payment Date</th>  
                        <th class="text-center tbl-iw nw">Total Amount</th>
                        <th class="text-center tbl-iw nw">Status</th>
                        <th class="text-center tbl-iw nw">Checked by Accounts</th>
                        <th>Document</th>        
                </thead>
                <tbody>
                    <?php
                    $payment_mode=array('1' => 'Cash', '2' => 'Cheque',3=>'Bank Transfer');
                    $condition = "1=1";
                    if ($employee_id != '') {
                        $condition .= ' AND employee_id= "' . $employee_id . '"';
                    }
                    if ($branch_id != '') {
                        $condition .= ' AND employeedetail.branch_or_sponsor_id= "' . $branch_id . '"';
                    }
                    if ($date_from != '') {
                        $from_date = date('Y-m-d', strtotime(str_replace('/', '-', $date_from)));
                        $condition .= ' AND created_date>= "' . $from_date . '"';
                    }
                    if ($date_to != '') {
                        $to_date = date('Y-m-d', strtotime(str_replace('/', '-', $date_to)));
                        $condition .= ' AND created_date<= "' . $to_date . '"';
                    }
                    if ($status != '') {
                        $condition .= ' AND status= "' . $status . '"';
                    }
                    $orderBy= 't.id asc';
                    if ($sort_field != '' && $sort_order != '') {
                         $orderBy = "t.".$sort_field . " " . $sort_order;
                     }


                    $model_user = User::model()->findByPk(Yii::app()->user->id);
                    if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                        $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
                    }
                    $arr_status=array('Y'=>'Yes','N'=>'No');
                    $model_expense = EmployeeExpense::model()->with('employeedetail')->findAll(array('condition' => $condition, 'order' => $orderBy ));
                    foreach ($model_expense as $j => $detail) {
                        ?>
                        <tr>
                            <td class="text-center tbl-iw nw"><?php echo $j + 1; ?></td>
                            <td class="text-center tbl-iw nw"><?php echo $detail->id; ?></td>
                            <td class="text-center tbl-iw nw"><?php echo $detail->employeedetail->branch_sponsor->branch_or_sponsor_name; ?></td>
                            <td class="text-center tbl-iw nw"><?php echo $detail->employeedetail->employeecode; ?></td>
                            <td class="text-left tbl-iw nw"><?php echo $detail->employeedetail->employeefullname; ?></td>
                            <td class="text-center tbl-iw nw"><?php
                                $apply_date = '';
                                if ($detail->created_date != '0000-00-00' && $detail->created_date != '') {
                                    $apply_date = date("d/m/Y", strtotime($detail->created_date));
                                }
                                echo $apply_date;
                                ?></td>
                            <td class="text-center tbl-iw nw"><?php
                                $approved_date = '';
                                if ($detail->approved_date != '0000-00-00' && $detail->approved_date != '') {
                                    $approved_date = date("d/m/Y", strtotime($detail->approved_date));
                                }
                                echo $approved_date;
                                ?></td> 
                            <td class="text-center tbl-iw nw"><?php
                            if($detail->payment_mode > 0)
                            {
                            echo $payment_mode[$detail->payment_mode]; 
                            }
                        ?></td>
                            <td class="text-center tbl-iw nw"><?php
                                $payment_date = '';
                                if ($detail->payment_date != '0000-00-00' && $detail->payment_date != '') {
                                    $payment_date = date("d/m/Y", strtotime($detail->payment_date));
                                }
                                echo $payment_date;
                                ?></td> 
                            <td class="text-right tbl-iw nw"><?php echo Yii::app()->numberFormatter->formatCurrency($detail->total, ""); ?></td>    
                            <td class="text-center tbl-iw nw"><?php echo EmployeeExpense::getStatus($detail->status, $detail->employeedetail->branch_or_sponsor_id); ?></td>    
                            <td class="text-center tbl-iw nw"><?php 
                            if($detail->status>=12){
                                echo $arr_status[$detail->accounts_verified]; 
                            }else{
                                echo '-';
                            }
                            ?></td>
                            <td class="col-md-2 text-center">
                                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_download']) || Yii::app()->user->authorised_user == 1) { ?>  
                                <?php
                                $model_document = EmployeeExpenseDetails::model()->find(array('condition' => 'expense_id="'.$detail->id.'" AND file!=""'));
                                if (!empty($model_document)):
                                    echo CHtml::link('<i class="fa fa-download"></i>', array('hrreports/downloadDocument&id='.$detail->id), array('title' => 'Download','class'=>"btn btn-warning btn-xs"));
                                endif;
                            }
                                ?>
                                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_view']) || Yii::app()->user->authorised_user == 1) { ?> 
                                <button class="btn btn-success btn-xs" onclick="loadPopupModal('hr/hrrequest/viewexpensehrapproveview&id=<?php echo $detail['id']; ?>', 'Expense', 'lg');return false;" title="View Expense Details"><i class="fa fa-eye"></i></button> 
                            <?php } ?>
                            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_print']) || Yii::app()->user->authorised_user == 1) { 
                                echo CHtml::link('<i class="fa fa-print"></i>', array('hrrequest/printexpensedetails&id='.$this->ciphertext($detail['id'],"e")), array('title' => 'Print','target'=>'_blank','class'=>"btn btn-info btn-xs"));   ?> 
                                
                            <?php } ?>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php //echo CHtml::link('PDF', array('hrreports/PrintExpenseReportPDF', 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'date_from' => $date_from, '$date_to' => $date_to), array('title' => 'Print Purchase report', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <!--<button type="button" class="btn btn-theme" onclick="excelexpenselist();">Excel</button>-->			  
            </div>
        </div>
    </div>
</div>
</div><?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("excelexpenselist", "function excelexpenselist(){    
    var branch_id = $('#branch_id').val();   
    var employee_id = $('#employee_id').val();    
    var from_date = $('#purchase_from_date').val();   
    var date_to = $('#to_date').val();   
    window.open($('#liveSite').val()+'index.php?r=hr/excel/PrintExpenseExcel&branch_id='+branch_id+'&employee_id='+employee_id+'&date_from='+from_date+'&date_to='+date_to, '_blank');
}", CClientScript::POS_HEAD);



