<?php
    $date_1='01/'.$month.'/'.$year;
    $from_date=$year.'-'.$month.'-01';
    $lastday = date('t',strtotime($from_date));
    $to_date=$year.'-'.$month.'-'.$lastday;
    $last_date=$lastday.'/'.$month.'/'.$year;
?>
<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Working Hours Report
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
            
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From :</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
             ?>
            <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To :</label>
                            <?php echo $to_date ?>
                        </div>
                    <?php
                }
             ?>
             <?php
                if($employee_id >0){
                    ?>
                        <div class="filter-item">
                            <label>Employee :</label>
                            <?php $emp = Employee::model()->findByPK($employee_id);
                                    echo $this->ciphertext($emp->first_name,"d").' '.$this->ciphertext($emp->middle_name,"d").' '.$this->ciphertext($emp->last_name,"d");; 
                                    
                                    ?>
                        </div>
                    
                    <?php
                }
            ?> 
            <?php
                if($month >0){
                    ?>
                        <div class="filter-item">
                            <label>Month :</label>
                            <?php echo HrGenerelSettings::getMonthName($month);?>
                        </div>
                    
                    <?php
                }
            ?> 
            <?php
                if($year >0){
                    ?>
                        <div class="filter-item">
                            <label>Year :</label>
                            <?php 
                                    echo $year; 
                                    
                                    ?>
                        </div>
                    
                    <?php
                }
            ?>
            <div class="filter-item">
                <label>Type : Weekly</label>                            
            </div>
                   </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
        
<?php       
    $from_date_11=$year.'-'.$month.'-01';
    $weekvalue_11=date('w', strtotime($from_date_11));
    $weekvalue_11+=1;
    if($weekvalue_11==6){
        $weekend_count=6;
    }else{
        $weekend_count=5;
    }
    $weekend_value=$weekend_count;
    $date=$from_date;
    $date1=date_create($from_date);
    $date2=date_create($to_date);
    $diff=date_diff($date1,$date2);
    $diff= $diff->format("%R%a days");
    $condition = '(t.isActive="Y" OR t.isActive="N")';  
    if($branch_id != '') { 
       $condition .= ' AND t.branch_or_sponsor_id = "'.$branch_id.'"'; 
    }   
    if($employee_id > 0) { 
       $condition .= ' AND t.id = "'.$employee_id.'"'; 
    }         
    $model_working_hours_11 = WorkingHours::model()->findAll(array('select'=>'week_id','condition'=>'company_branch_or_sponsor_id = "'.$branch_id.'" and weekend="0"'));
    $model_working_hours12=array();
    foreach ($model_working_hours_11 as $key_value => $hr_value) {
        $model_working_hours12[$key_value]=$hr_value->week_id;
    }
    $modelemployee = Employee::model()->findAll(array('condition'=>$condition,'order'=>'first_name'));
    $model_working_hours = WorkingHours::model()->find(array('select'=>'max(week_id) as week_id','condition'=>'company_branch_or_sponsor_id = "'.$branch_id.'" and weekend="0"'));
    $arr_week_working=array();
    $arr_working_hour=array();
    foreach ($modelemployee as $key => $empdetail) {
        $total_working_days=0;
        $date=$from_date;
        $weekend_value=$weekend_count;
         $s=0;
        $total_hours_in_month='00:00';
        for ($k=0;$k<=$diff;$k++) {
            $weekvalue=date('w', strtotime($date));
            $weekvalue+=1;
           //            Working Days
            $model_holiday = MasHoliday::model()->find(array('condition' =>'holiday_date="'.$date.'"'));
            if(!in_array($weekvalue, $model_working_hours12) && empty($model_holiday)){
               $total_working_days++;
            }
           //Attendance 
            $time1='';
            $actual_diff='';
            $model_attendance=EmployeeAttendance::model()->find(array('condition'=>'employee_id="'.$empdetail->id.'" and attendance_date="'.$date.'"'));                                              
            if(!empty($model_attendance)){
                 if($model_attendance->status==1){   
                    $login_time = $model_attendance->login_time;
                    $logout_time = $model_attendance->logout_time;                                  
                    $from_time      = strtotime($model_attendance->login_time);
                    $to_time        = strtotime($model_attendance->logout_time);
                    $actual_diff    = $to_time - $from_time;   
                    $actual_diff=gmdate('H:i', $actual_diff); 
                    $time1 = strtotime($actual_diff, 0);                                    ;
                    $total_hours+=$time1;
                    $total_hours_in_month+=$time1;
                 }
            }
        if($weekvalue==$model_working_hours->week_id){   
                $hours = floor($total_hours / 3600);
                $minutes = ($total_hours % 3600) / 60; 
                $working_hr=$hours.':'.$minutes;   
                $arr_working_hour[$key][$s]['hour']=$working_hr;
                 $arr_working_hour[$s]['lastdate']=$date;
                if($hours>=45){
                    $row_color='bg-normal';
                }else if($hours>=40){
                    $row_color='bg-intermediate';
                }else{
                    $row_color='bg-lesswork';
                }
            $arr_working_hour[$key][$s]['color']=$row_color;
                $weekend_value--;
                $total_hours='00:00';
                $s++;
        }
           $date = date('Y-m-d', strtotime($date . ' +1 day'));
        }
        $hours_1 = floor($total_hours_in_month / 3600);
        $minutes_1 = ($total_hours_in_month % 3600) / 60; 
        $working_hr_1=$hours_1.':'.$minutes_1;   
                
        if($weekend_value!=$s){
            $arr_working_hour[$key][$s]['hour']=$working_hr;
            $arr_working_hour[$key][$s]['lastdate']=$to_date;
            if($hours>=45){
                $row_color='bg-normal';
            }else if($hours>=40){
                $row_color='bg-intermediate';
            }else{
                $row_color='bg-lesswork';
            }
            $arr_working_hour[$key][$s]['color']=$row_color;
        }
                
          $arr_week_working[$key]['id']= $this->ciphertext($empdetail->employee_code,"d"); 
          $arr_week_working[$key]['employee_biometric_code']= $empdetail->employee_biometric_code;
          $arr_week_working[$key]['branch']= $empdetail->branch_sponsor->branch_or_sponsor_name;
          $arr_week_working[$key]['name']= $this->ciphertext($empdetail->first_name,"d").' '.$this->ciphertext($empdetail->middle_name,"d").' '.$this->ciphertext($empdetail->last_name,"d");
          $arr_week_working[$key]['total']=$working_hr_1;       
            $row_color_total='';
           $total_company_working=$total_working_days*9;  
            $total_company_working_1=$total_working_days*8;  
           if($hours_1>=$total_company_working){
               $row_color_total='bg-normal';
           }else if($hours_1>=$total_company_working_1){
               $row_color_total='bg-intermediate';
           }else{
               $row_color_total='bg-lesswork';
           }
             $arr_week_working[$key]['colortotal']=$row_color_total;
    } 
?>        
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw">No</th>
                        <th class="">ID</th>
                        <th class="">Bio ID</th>
                        <th class="">Branch</th>
                        <th class="text-center tbl-iw nw">Name</th>
                        <?php 
                        for ($m= 0;$m <$weekend_count; $m++) { ?>
                            <th class="">Week-<?php echo $m+1; ?> <br/> Date  ( <?php echo date('d/m/Y',strtotime($arr_working_hour[$m]['lastdate'])); ?> )</th>
                       <?php
                        }
                        ?>
                        <th class="">Total   <br/>(<?php echo $total_company_working; ?>)</th>
                      </tr>
                </thead>
                <tbody>
                    <?php
                        for ($n= 0;$n <count($arr_week_working); $n++) { ?>
                        <tr <?php echo $tr_class;?> >
                            <td><?php echo $n+1; ?></td>
                            <td><?php  echo $arr_week_working[$n]['id']; ?></td>
                            <td><?php  echo $arr_week_working[$n]['employee_biometric_code']; ?></td>
                            <td><?php  echo $arr_week_working[$n]['branch']; ?></td>
                            <td><?php echo $arr_week_working[$n]['name']; ?></td>
                            <?php 
                                for ($m= 0;$m <$weekend_count; $m++) { ?>
                                    <td class="text-center <?php echo $arr_working_hour[$n][$m]['color']; ?>"><?php echo $arr_working_hour[$n][$m]['hour']; ?></td>
                            <?php
                             }
                            ?>  
                                    <td class="<?php echo  $arr_week_working[$n]['colortotal']; ?>"><?php echo $arr_week_working[$n]['total']; ?></td>
                        </tr>
                     <?php   }
                        ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php
             echo CHtml::link('PDF',array('reports/PrintEmpWeeklyWorkinhHoursPDF','branch_id'=>$branch_id,'month'=>$month,'year'=>$year,'employee_id'=>$employee_id,'working_report_type'=>$working_report_type), array('title'=>'Print List','target'=>'_blank','class' =>  'btn btn-theme')); ?>
                     <button type="button" class="btn btn-theme" onclick="excelWorkingHoursdailyList();">Excel</button>			  <input type="hidden" value="<?php echo $branch_id ?>" id="branch_id">			  <input type="hidden" value="<?php echo $month ?>" id="month">			  <input type="hidden" value="<?php echo $employee_id ?>" id="employee_id">			  <input type="hidden" value="<?php echo $working_report_type ?>" id="working_report_type">
        </div>
        </div>
    </div>
</div><?php $cs = Yii::app()->getClientScript(); $cs->registerScript("excelWorkingHoursdailyList", "function excelWorkingHoursdailyList(){    var branch_id = $('#branch_id').val();    var month = $('#month').val();     var employee_id = $('#employee_id').val();    var working_report_type = $('#working_report_type').val();	  window.open($('#liveSite').val()+'index.php?r=hr/excel/printWorkingHoursweeklyExcel&branch_id='+branch_id+'&month='+month+'&employee_id='+employee_id+'&working_report_type='+working_report_type, '_blank');}", CClientScript::POS_HEAD);