<?php
    $date_1='01/'.$month.'/'.$year;
    $from_date=$year.'-'.$month.'-01';
    $lastday = date('t',strtotime($from_date));
    $to_date=$year.'-'.$month.'-'.$lastday;
    $last_date=$lastday.'/'.$month.'/'.$year;
?>
<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Attendance Report
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
            
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From :</label>
                            <?php echo $date_1 ?>
                        </div>
                    <?php
                }
             ?>
            <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To :</label>
                            <?php echo $last_date ?>
                        </div>
                    <?php
                }
             ?>
             <div class="filter-item">
                <label>Month :</label><?php  echo HrGenerelSettings::getMonthName($month); ?>
             </div>
             <div class="filter-item">
                <label>Year :</label><?php  echo $year; ?>
             </div>
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
        
<?php 
    
    $date=$from_date;
    $date1=date_create($from_date);
    $date2=date_create($to_date);
    $diff=date_diff($date1,$date2);
    $diff= $diff->format("%R%a days");
    $model_working_hours = WorkingHours::model()->findAll(array('select'=>'week_id','condition'=>'company_branch_or_sponsor_id = "'.$branch_id.'" and weekend="0"'));
    $arr_week_working=array();  
    $after_weekend=array();
    $before_weekend=array();    
    foreach ($model_working_hours as $key_1 => $value_1) {                                   
        $before_weekend[$key_1]=$value_1->week_id-1;
        $after_wek_value=$value_1->week_id+1;
        $value_1_week_id=0;
        if($after_wek_value>7){
            $value_1_week_id=1;
        }else{
            $value_1_week_id=$value_1->week_id+1;
        }
        $after_weekend[$key_1]=$value_1_week_id;                                 
    }
    $arr_week_working=array_merge($before_weekend,$after_weekend);    
    foreach ($model_working_hours as $key_1 => $value_1) {
        if (($key = array_search($value_1->week_id, $arr_week_working)) !== false) {
            unset($arr_week_working[$key]);
            $arr_week_working = array_values($arr_week_working); 
        }
    } 
    //Get all weekends
    $model_working_hours = WorkingHours::model()->findAll(array('select'=>'week_id','condition'=>'company_branch_or_sponsor_id = "'.$branch_id.'" and weekend="0"'));

    $arr_day_value=array();    
    foreach ($arr_week_working as $key_12 => $value) {
         $arr_day_value[$key_12]=SalaryProcessing::getday($value);

    } 
    $arr_date=array();
    $f=0;
    $begin  = new DateTime($from_date);
    $end    = new DateTime($to_date);
    while ($begin <= $end) // Loop will work begin to the end date 
    {
        if(in_array($begin->format("D"), $arr_day_value))
        {
            $arr_date[$f]['date']= $begin->format("Y-m-d");
            $arr_date[$f]['day']= $begin->format("D");
            $f++;
        }
        $begin->modify('+1 day');
    }                            
?>       
            <table class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw">No</th>
                        <th class="">ID</th>
                        <th class="">Branch</th>
                        <th class="text-center tbl-iw nw">Name</th>
                        <?php
                            foreach ($arr_date as $value) { ?>
                        <th class="text-center tbl-iw nw"><?php echo date('d/m/Y',strtotime($value['date'])); ?><br/><?php echo $value['day']; ?></th>                    
                           <?php
                           }
                        ?>
                      </tr>
                </thead>
                <tbody>
                    <?php
                        $j=1;
                        $condition = '(t.isActive="Y" OR t.isActive="N")';  
                        if($branch_id != '') { 
                           $condition .= ' AND t.branch_or_sponsor_id = "'.$branch_id.'"'; 
                        }  
                        if($employee_id!=''){
                            $condition .= ' AND t.id = "'.$employee_id.'"'; 
                        }
                        $modelemployee = Employee::model()->findAll(array('condition'=>$condition,'order'=>'first_name'));
                        $arr_employee=array();
                        foreach ($modelemployee as $key => $value) {
                            $arr_employee[$value['employeefullname']]=$value['id'];
                        }
                        ksort($arr_employee);      
                        if(!empty($arr_employee)){
                            foreach ($arr_employee as $emp_id) {
                                $empdetail = Employee::model()->findbyPK($emp_id);
                                $weekend_arr=array();
                                $weekend_1=$empdetail->weekend_off1;
                                if($weekend_1>0){
                                    if($weekend_1==1){
                                        $weekend_arr[]=7;
                                        $weekend_arr[]=2;
                                    }elseif($weekend_1==7){
                                        $weekend_arr[]=6;
                                        $weekend_arr[]=1;
                                    }else{
                                        $weekend_arr[]=$weekend_1-1;
                                        $weekend_arr[]=$weekend_1-1;
                                    }
                                }
                                $weekend_2=$empdetail->weekend_off2;
                                if($weekend_2>0){
                                    if($weekend_2==1){
                                        $weekend_arr[]=7;
                                        $weekend_arr[]=2;
                                    }elseif($weekend_2==7){
                                        $weekend_arr[]=6;
                                        $weekend_arr[]=1;
                                    }else{
                                        $weekend_arr[]=$weekend_2-1;
                                        $weekend_arr[]=$weekend_2-1;
                                    }
                                }
                                $weekend_3=$empdetail->weekend_off3;
                                if($weekend_3>0){
                                    if($weekend_3==1){
                                        $weekend_arr[]=7;
                                        $weekend_arr[]=2;
                                    }elseif($weekend_3==7){
                                        $weekend_arr[]=6;
                                        $weekend_arr[]=1;
                                    }else{
                                        $weekend_arr[]=$weekend_3-1;
                                        $weekend_arr[]=$weekend_3-1;
                                    }
                                } 
                                print_r($weekend_arr);
                                ?>
                            <tr>
                                <td><?php echo $key+1; ?></td>
                                <td><?php echo $empdetail->employeecode; ?></td>
                                <td><?php echo $empdetail->branch_sponsor->branch_or_sponsor_name; ?></td>
                                <td><?php echo $empdetail->employeefullname; ?></td>
                            <?php       
                                foreach ($arr_date as $value) {
                                    $status_color='';
                                    $model_attendance=EmployeeAttendance::model()->find(array('condition'=>'employee_id="'.$empdetail->id.'" and attendance_date="'.$value['date'].'" and (status="2" or status="4" or status="7" or status="5" or status="9")'));                                              
                                    $status='';
                                    if(!empty($model_attendance)){
                                        $status_color='bg-lesswork';
                                        $status=EmployeeAttendance::geAttendanceStatus($model_attendance->status);
                                     }
                            ?>
                                <td class="<?php echo $status_color; ?> text-center text-bold"> <?php echo $status; ?></td>
                            <?php
                                }                                                                   
                            ?>                                
                            </tr>
                                <?php                              
                            }
                        }
                        ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('PDF', array('hrreports/PrintWeekendLeavePDF', 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'date_from' => $date_from, '$date_to' => $date_to), array('title' => 'Print Purchase report', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="excelattendancelist();">Excel</button>			  
            </div>
        </div>
    </div>
</div>
<?php $cs = Yii::app()->getClientScript(); 
$cs->registerScript("excelattendancelist", "function excelattendancelist(){
    var branch_id = $('#weekendleave_emp_sponsor').val();   
    var employee_id = $('#weekendleave_emp_id').val();    
    var month = $('#weekendleave_month').val();   
    var year = $('#weekendleave_year').val();   
    window.open($('#liveSite').val()+'index.php?r=hr/excel/PrintWeekendExcel&branch_id='+branch_id+'&employee_id='+employee_id+'&month='+month+'&year='+year, '_blank');
}", CClientScript::POS_HEAD);