 <?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<style>
.bg-weekend {
    background: #ffff63 !important;
    display: block;
    text-align: center;

}
.bg-absent {
    background: rgba(255, 0, 0, 0.84) !important;
    color: #FFF;
    display: block;
    text-align: center;
}
.bg-present {
    background: #a1ffa1 !important;
    display: block;
    text-align: center;
}
.bg-holiday {
    background: #02df02 !important;
    display: block;
    text-align: center;
}
.bg-medical {
    background: #ffbc2a !important;
    display: block;
    text-align: center;
}
.bg-Annual {
    background: #ffcccc !important;
    display: block;
    text-align: center;
}
.bg-emergency {
    background: #ff7d7d !important;
    display: block;
    text-align: center;
}

th, td { white-space: nowrap;}
   /* div.dataTables_wrapper {
        width: 800px;
        margin: 0 auto;
    }*/  
</style>
<script>

     $(document).ready(function () {
        var table_id = "#tbl_monthly_attendance_list";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.branch_id  = $("#branch_id").val();
            data.month      = $("#month").val();
            data.year       = $("#year").val();
            return data;
        }).DataTable({
//            scrollY:        "345px",
            scrollX:        true,
//            scrollCollapse: true,
            paging:        true,
            bInfo: false,
            searching: false,
            ordering: false,  // Disable sorting functionality globally
            fixedColumns: {
                leftColumns: 3
            },
            pageLength: 50,  // Set the number of rows to load per page to 100
            ajax: {
                url: "<?php echo Yii::app()->createUrl('hr/hrreports/GetPrintMonthlyAttendanceReportList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
             'rowCallback': function(row, data, index){
                    $(row).find('td:eq(0)').css('background-color', '#ddd');
                    $(row).find('td:eq(1)').css('background-color', '#ddd');
              },
          
    
        });
    
     });
</script>


   <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-calendar"></i>  Monthly Attendance Report
            <div class="pull-right">
                </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_monthly_attendance_list">
                    <thead>
                        <tr>
                        <th>Emp ID</th>
                        <th>Emp Name</th>
                        <th>MOL No</th>
                        <?php
                            $date      = $year.'-'.$month.'-01';
                            $lastday   = date('t',strtotime($date));
                            $last_date = $year.'-'.$month.'-'.$lastday;
                            $date_fm   = $year.'-'.$month.'-01';
                            $days      = cal_days_in_month(CAL_GREGORIAN,$month,$year);
                            for($i=1;$i<=$days;$i++){
                                echo '<th>'.$i.'</th>';
                            }?>
                        
                        <th>P</th>
                        <th>AB</th>
                        <th>HD</th>
                        <th>W</th>
                        <th>L</th>
                        <th><b>Total</b></th>
                        <th class="tbl-iw nw"><b>Total Variance</b></th>
                        </tr>
                </thead>
                </table>
            </div>
            <br/>
            <div>
                <?php  $heads='P- Present ,
                        AB - Absent,
                        HD - Holiday,
                        FW  - Weekend(Full Day)
                        HW  - Weekend(Half Day)';
                $mod_leave= MasLeave::model()->findAll(array('condition'=>'isActive="Y"'));
                foreach ($mod_leave as $eachleav){
                    $heads .=' ,
                             '.$eachleav->leave_abbreviation.' - '.$eachleav->leave_name;

                }
                echo $heads;
?>
            </div>
        </div>
    </section>
