<?php
    $date_1='01/'.$month.'/'.$year;
    $from_date=$year.'-'.$month.'-01';
    $lastday = date('t',strtotime($from_date));
    $to_date=$year.'-'.$month.'-'.$lastday;
    $last_date=$lastday.'/'.$month.'/'.$year;
?>
<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Working Hours Report
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
            
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From :</label>
                            <?php echo $date_1 ?>
                        </div>
                    <?php
                }
             ?>
            <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To :</label>
                            <?php echo $last_date ?>
                        </div>
                    <?php
                }
             ?>
             <?php
                if($employee_id >0){
                    ?>
                        <div class="filter-item">
                            <label>Employee :</label>
                            <?php $emp = Employee::model()->findByPK($employee_id);
                                    echo $this->ciphertext($emp->first_name,"d").' '.$this->ciphertext($emp->middle_name,"d").' '.$this->ciphertext($emp->last_name,"d");; 
                                    
                                    ?>
                        </div>
                    
                    <?php
                }
            ?> 
            <?php
                if($month >0){
                    ?>
                        <div class="filter-item">
                            <label>Month :</label>
                            <?php echo HrGenerelSettings::getMonthName($month);?>
                        </div>
                    
                    <?php
                }
            ?> 
            <?php
                if($year >0){
                    ?>
                        <div class="filter-item">
                            <label>Year :</label>
                            <?php 
                                    echo $year; 
                                    
                                    ?>
                        </div>
                    
                    <?php
                }
            ?>
            <div class="filter-item">
                <label>Type : Daily</label>                            
            </div>
                   </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th class="text-center">No</th>                       
                        <th class="text-center">Date</th>
                        <th class="text-center">Login time</th>
                        <th class="text-center">Logout time</th>
                        <th class="text-center">Working Hours</th>
                      </tr>
                </thead>
                <tbody>
                    <?php
                        $date=$from_date;
                        $date1=date_create($from_date);
                        $date2=date_create($to_date);
                        $diff=date_diff($date1,$date2);
                        $diff= $diff->format("%R%a days");
                        $j=1;  
                        $total_hours='00:00';                     
                        $model_working_hours_11 = WorkingHours::model()->findAll(array('select'=>'week_id','condition'=>'company_branch_or_sponsor_id = "'.$model_employee->branch_or_sponsor_id.'" and weekend="0"'));
                        $model_working_hours12=array();
                        foreach ($model_working_hours_11 as $key_value => $hr_value) {
                            $model_working_hours12[$key_value]=$hr_value->week_id;
                        }
                        $total_working_days=0;
                            for ($k=0;$k<=$diff;$k++) {
                                $weekvalue+=1;
                                //            Working Days
                                $model_holiday = MasHoliday::model()->find(array('condition' =>'holiday_date="'.$date.'"'));
                                if(!in_array($weekvalue, $model_working_hours12) && empty($model_holiday)){
                                   $total_working_days++;
                                }
                                $actual_diff='';
                                $time1='';
                                $tr_class='';
                                $model_attendance=EmployeeAttendance::model()->find(array('condition'=>'employee_id="'.$employee_id.'" and attendance_date="'.$date.'"'));                                              
                                if(!empty($model_attendance)){
                                    if($model_attendance->status==1){                                
                                        $login_time = $model_attendance->login_time;
                                        $logout_time = $model_attendance->logout_time;                                  
                                        $from_time      = strtotime($model_attendance->login_time);
                                        $to_time        = strtotime($model_attendance->logout_time);
                                        $actual_diff    = $to_time - $from_time;   
                                        $actual_diff=gmdate('H:i', $actual_diff); 
                                        $time1 = strtotime($actual_diff, 0);                                    ;
                                        $total_hours+=$time1;
                                        $working_hour=strtotime('09:00', 0);  
                                        $working_hour_1=strtotime('08:00', 0);
                                        if($time1>=$working_hour){
                                              $tr_class="bg-normal";
                                        }else if($time1>=$working_hour_1){
                                            $tr_class="bg-intermediate";
                                        }else{
                                           $tr_class="bg-lesswork";
                                        }
                                    }else{
                                        $login_time='-';
                                        $logout_time='-';                   
                                    }
                                }else{
                                    $login_time='-';
                                    $logout_time='-';  
                                }
                                ?>
                                    <tr class="<?php echo $tr_class;?> ">
                                        <td class="text-center"><?php echo $j; ?></td>                          
                                        <td class="text-center"><?php echo date_format(date_create($date),'d/m/Y'); ?></td>
                                        <td class="text-right"><?php echo $login_time; ?></td>
                                        <td class="text-right"><?php echo $logout_time; ?></td>
                                        <td class="text-right"><?php echo $actual_diff;?></td>
                                    </tr>
                                <?php
                                $date = date('Y-m-d', strtotime($date . ' +1 day'));
                                $j++;                                
                            }
                            $row_color_total='';
                            //Weekend days
                            $weekend_count= EmployeeAttendance::model()->count(array('condition' => 'employee_id="' .$employee_id. '" AND attendance_date>="' . $from_date . '" AND attendance_date<="' . $to_date . '" and status="5"'));
                            $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`logout_time`)-time_to_sec(`login_time`))) As logout_time', 'condition' => 'employee_id="' .$employee_id. '" AND attendance_date>="' . $from_date . '" AND attendance_date<="' . $to_date . '"'));
                            $tot_wrk_hr=  explode(':',$model_attendance->logout_time);                            
                            $hours = $tot_wrk_hr[0];
                            $minutes = $tot_wrk_hr[1]; 
                            $total_company_working=($total_working_days-$weekend_count)*9; 
                            $total_company_working_1=($total_working_days-$weekend_count)*8; 
                            if($hours>=$total_company_working){
                                $row_color_total='bg-normal';
                            }else if($hours>=$total_company_working_1){
                                $row_color_total='bg-intermediate';
                            }else{
                                $row_color_total='bg-lesswork';
                            }
                        ?>
                        <tr>
                            <td colspan="4" class="text-bold text-right">Total Hours</td>
                            <td class="text-bold text-right <?php echo $row_color_total; ?>"><?php   
                            echo $hours.':'.$minutes; ?></td>
                        </tr>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php
           echo CHtml::link('PDF',array('reports/PrintEmployeeworkingHoursPDF','branch_id'=>$branch_id,'month'=>$month,'year'=>$year,'employee_id'=>$employee_id,'working_report_type'=>$working_report_type), array('title'=>'Print Credit List','target'=>'_blank','class' =>  'btn btn-theme')); ?>
                    
         <button type="button" class="btn btn-theme" onclick="excelWorkingHoursdailyList();">Excel</button>
			  <input type="hidden" value="<?php echo $branch_id ?>" id="branch_id">
			  <input type="hidden" value="<?php echo $month ?>" id="month">
			  <input type="hidden" value="<?php echo $employee_id ?>" id="employee_id">
			  <input type="hidden" value="<?php echo $working_report_type ?>" id="working_report_type">
        </div>
        </div>
    </div>
</div>
<?php $cs = Yii::app()->getClientScript(); 

$cs->registerScript("excelWorkingHoursdailyList", "function excelWorkingHoursdailyList(){
    var branch_id = $('#branch_id').val();    var month = $('#month').val();     var employee_id = $('#employee_id').val();    var working_report_type = $('#working_report_type').val();	
  window.open($('#liveSite').val()+'index.php?r=hr/excel/printWorkingHoursdailyExcel&branch_id='+branch_id+'&month='+month+'&employee_id='+employee_id+'&working_report_type='+working_report_type, '_blank');

}", CClientScript::POS_HEAD);