<!DOCTYPE html>
<html>
    <head>
        <title>Annual Leave Report</title>
    </head>
    <body>
        <div class="heading">
            <div class="logo col-6">
                <img src="images/pdf/logo.png">
            </div>

        </div>
        <div class="clearfix"></div>
        <div class="title">
            <div class="col-6">
                <div style="height: 10px;"></div>
            </div>
            <div class="col-6 text-right">
                <h1>Annual Leave</h1>
                <div class="details-box">
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="table-body">
            <table class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw">No</th>
                        <th class="text-center tbl-iw nw">ID</th>                    
                        <th class="text-center tbl-iw nw">Name</th>        
                        <th class="text-center tbl-iw nw">Position</th>     
                        <th class="text-center tbl-iw nw">Joining Date</th> 
                        <th class="text-center tbl-iw nw">Annual Leave Availed</th> 
                        <th class="text-center tbl-iw nw">Sick Leave Availed</th> 
                        <th class="text-center tbl-iw nw">Personal Leave Availed</th> 
                        <th class="text-center tbl-iw nw">Vacation Days Eligible <br/><?php echo date('Y'); ?></th> 
                        <th class="text-center tbl-iw nw">Vacation Days Balance <br/><?php echo date('Y'); ?></th> 
                        <th class="text-center tbl-iw nw">Carried Over leaves <br/><?php echo date('Y') - 1; ?></th> 
                </thead>
                <tbody>
                    <?php
                    $condition = "branch_or_sponsor_id='" . $branch_id . "'";
                    if ($employee_id != '') {
                        $condition .= ' AND id= "' . $employee_id . '"';
                    }
                    $model_user = User::model()->findByPk(Yii::app()->user->id);

                        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                          $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
                        }
                    $model_employee = Employee::model()->findAll(array('condition' => $condition));
                    foreach ($model_employee as $j => $detail) {
                        $joining_date = "";
                        if ($detail->date_join != '' && $detail->date_join != '0000-00-00') {
                            $joining_date = date("d/m/Y", strtotime($detail->date_join));
                        }
                        $annual_leave_availed=EmployeeAttendance::model()->with('leave.leavetype')->count(array('condition' => 't.employee_id="'.$detail->id.'" and YEAR(attendance_date)="'.date('Y').'" and leavetype.is_annual_leave="Y"'));
                        $sick_leave_availed=EmployeeAttendance::model()->with('leave.leavetype')->count(array('condition' => 't.employee_id="'.$detail->id.'" and YEAR(attendance_date)="'.date('Y').'" and leavetype.leave_abbreviation="SL"'));
                        $personal_leave_availed=EmployeeAttendance::model()->with('leave.leavetype')->count(array('condition' => 't.employee_id="'.$detail->id.'" and YEAR(attendance_date)="'.date('Y').'" and leavetype.leave_abbreviation="PL"'));
                        $annual_leave_balance_year = EmployeeLeave::model()->with('leavetype')->find(array('condition' => 't.employee_id="' .$detail->id. '" AND leavetype.is_annual_leave="Y" AND leave_year="'.date('Y').'"'))->leave_current_balance;
                        $annual_leave_previous_year = EmployeeLeave::model()->with('leavetype')->find(array('condition' => 't.employee_id="' .$detail->id. '" AND leavetype.is_annual_leave="Y" AND leave_year="'.date('Y').'"'))->leave_opening;
                        $model_annual_leave_eligibile= EmployeeLeave::model()->with('leavetype')->find(array('condition' => 't.employee_id="' .$detail->id. '" AND leavetype.is_annual_leave="Y" AND leave_year="'.date('Y').'"'));
                        $current_balance = $model_annual_leave_eligibile->leave_current_balance;
                        $total_eligible_leave = $annual_leave_previous_year;
                        //Leave addition
                        $employee_leave_added=EmployeeLeaveLedger::model()->with('leavetype')->find(array('select'=>'sum(leave_count) as leave_count','condition' => 't.employee_id="'.$detail->id.'" and YEAR(t.created_date_time)="'.date('Y').'" and leavetype.is_annual_leave="Y"'));
                        if($employee_leave_added->leave_count>0){
                            $total_eligible_leave+=$employee_leave_added->leave_count;
                        }
                        //Leave deduction
                        $employee_leave_deducted=EmployeeLeaveLedger::model()->with('leavetype')->find(array('select'=>'sum(leave_reduce) as leave_reduce','condition' => 't.employee_id="'.$detail->id.'" and YEAR(t.created_date_time)="'.date('Y').'" and leavetype.is_annual_leave="Y"'));
                        if($employee_leave_deducted->leave_reduce>0){
                            $total_eligible_leave-=$employee_leave_deducted->leave_reduce;
                        }
                        if ($model_annual_leave_eligibile->leavetype->leave_type == 1) {
                            //Get Max Salary Details
                            $last_date = date('Y-12-31');
                            $model_max_id = SalarySlip::model()->with('processing')->find(array('select' => 'MAX(salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" AND employee_id="' . $detail->id . '"'));
                            if ($model_max_id->salary_processing_id > 0) {
                                $model_salry_processing = SalaryProcessing::model()->findbyPk($model_max_id->salary_processing_id);
                                $payroll_dt = $model_salry_processing->payroll_enddate;

                                $date_for_advnc_1 = strtotime($payroll_dt);
                                $date_for_advnc_2 = strtotime($last_date);
                                $year11 = date('Y', $date_for_advnc_1);
                                $year12 = date('Y', $date_for_advnc_2);
                                $month11 = date('m', $date_for_advnc_1);
                                $month12 = date('m', $date_for_advnc_2);
                                $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                                $total_eligible_leave+=($advance_leave_month * $model_annual_leave_eligibile->leavetype->leave_days);
                            } else {
                                $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $detail->branch_or_sponsor_id . '"'));
                                if ($model_lock_month->id == '') {
                                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                                }
                                $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $detail->branch_or_sponsor_id . '"'));
                                if ($model_lock_days->id == '') {
                                    $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                                }
                                $salary_last_date = $model_lock_month->payroll_year . '-' . $model_lock_month->payroll_month . '-' . $model_lock_days->payroll_start_day;
                                // $salary_last_date=date('Y-m-d', strtotime('+1 month', strtotime($salary_last_date)));
                                $date_for_advnc_1 = strtotime($salary_last_date);
                                $date_for_advnc_2 = strtotime($last_date);
                                $year11 = date('Y', $date_for_advnc_1);
                                $year12 = date('Y', $date_for_advnc_2);
                                $month11 = date('m', $date_for_advnc_1);
                                $month12 = date('m', $date_for_advnc_2);
                                $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                                $total_eligible_leave+=$advance_leave_month * $model_annual_leave_eligibile->leavetype->leave_days;
                            }
                        }
                        ?>
                        <tr>
                            <td class="text-center tbl-iw nw"><?php echo $j + 1; ?></td>
                            <td class="text-center tbl-iw nw"><?php echo $detail->employeecode; ?></td>
                            <td class="text-left tbl-iw nw"><?php echo $detail->employeefullname; ?></td> 
                            <td class="text-left tbl-iw nw"><?php echo $detail->designationdetail->designation_name; ?></td> 
                            <td class="text-left tbl-iw nw"><?php echo $joining_date; ?></td> 
                            <td class="text-center tbl-iw nw"><?php echo $annual_leave_availed; ?></td> 
                            <td class="text-center tbl-iw nw"><?php echo $sick_leave_availed; ?></td> 
                            <td class="text-center tbl-iw nw"><?php echo $personal_leave_availed; ?></td> 
                            <td class="text-center tbl-iw nw"><?php echo number_format((float) $total_eligible_leave, 2, '.', ''); ?></td> 
                            <td class="text-center tbl-iw nw"><?php echo $annual_leave_balance_year; ?></td> 
                            <td class="text-center tbl-iw nw"><?php echo $annual_leave_previous_year; ?></td> 
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <!--    mpdf
                <htmlpagefooter name="myfooter">
                    <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
                        <div style="text-align:center;width:100%">This report is auto generated by Bluesky project on 
        <?php
        date_default_timezone_set("Asia/Dubai");
        echo date('d/m/Y') . " " . date("h:i:sa");
        ?> </div>
                        <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
                    </div>
                </htmlpagefooter>
                <sethtmlpagefooter name="myfooter" page="all" value="on" />-->

    </body>
</html>
