<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadleave", '
    function filterDataTable() {
        var table_id ="#tbl_employeeoffboard_details";
        var branch_id = $("#branch_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hronboarding/GetEmployeeList') . '",
                type: "POST",
                data : {
                    "branch_id" : branch_id                 
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	
      filterDataTable();
    })
	
	', CClientScript::POS_HEAD);
?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">Off Boarding Details
            <div class="pull-right">
                 <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_off_boarding_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                     <a class="ad-btn" title="Add" onclick="loadPopupModal('hr/hronboarding/offcreate&branch=<?php echo  $branch; ?>','Offboarding','lg')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
            <input type="hidden" id="branch_id" name="branch_id" value="<?php echo  $branch; ?>"/>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_employeeoffboard_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Created Date</th>
                            <th>Actions</th>                                                    
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
