<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'hrnotification-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">

        <ul class="clearfix form-ul material">

            <?php echo $form->hiddenField($model, 'id'); ?>

            <li class="col-sm-4" >
                <?php
                $selected = array();
                if($model->id >0)
                {
                $keys = explode(',', $model->branch);
                $selected = array();
                foreach ($keys as $value) {
                    $selected[$value] = array('selected' => true);
                }
              }

                echo $form->dropdownlist($model, 'branch', MasCompanyBranchSponsor::getCompanyBranches(), array('options' => $selected, 'data-label' => 'Branch <span style="color:red">*</span>', 'multiple' => true, 'onChange' => 'javascript:loadEmployee()'));
                ?>
                <?php echo $form->error($model, 'branch'); ?>
            </li>
            <li class="col-sm-4" >
                <?php
                  $selected = array();
                  if($model->id >0)
                  {
                $keys = explode(',', $model->department_id);
                $selected = array();
                foreach ($keys as $value) {
                    $selected[$value] = array('selected' => true);
                }
               }
                echo $form->dropdownlist($model, 'department_id', MasDepartment::getDepartment(), array('options' => $selected, 'data-label' => 'Department ', 'multiple' => true, 'onChange' => 'javascript:loadEmployee()'));
                ?>
                <?php echo $form->error($model, 'department_id'); ?>
            </li>
            <li class="col-sm-4">
                <?php
                  $selected = array();
                  if($model->id >0)
                  {
                $keys = explode(',', $model->designation);
                $selected = array();
                foreach ($keys as $value) {
                    $selected[$value] = array('selected' => true);
                }
                }

                echo $form->dropdownlist($model, 'designation', MasDesignation::getDesignation(), array('options' => $selected, 'data-label' => 'Designation', 'multiple' => true, 'onChange' => 'javascript:loadEmployee()'));
                ?>

                <?php echo $form->error($model, 'designation'); ?>
            </li>
            <li class="col-sm-4">

                <div id="emp_id">
                    <?php
                      $selected = array();
                      if($model->id >0)
                      {
                    $keys = explode(',', $model->employee_id);
                    $selected = array();
                    foreach ($keys as $value) {
                        $selected[$value] = array('selected' => true);
                    }}

                    echo $form->dropdownlist($model, 'employee_id', Employee::getEmployee(), array('class'=>'notifyEmp','options' => $selected, 'data-search' => 'true', 'selected' => 'selected', 'data-label' => 'Employee <span style="color:red">*</span>', 'multiple' => 'multiple'));
                    ?>

                    <?php echo $form->error($model, 'employee_id'); ?>
                </div>
            </li>

            <li class="col-sm-8">

                <?php echo $form->textField($model, 'title', array('data-label' => 'Title <span style="color:red">*</span>')); ?>
                <?php echo $form->error($model, 'title'); ?>
            </li>
            <li class="col-sm-12">
                <?php echo $form->textArea($model, 'content', array('data-label' => 'Description <span style="color:red">*</span>','class' => 'ckeditor go','id'=>'HrNotification_content')); ?>
                <?php echo $form->error($model, 'content'); ?>
            </li>

        </ul>
    </div>

</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="hr_notify_close">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/hrnotification/Save');
    
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'data'=>'js:$("#hrnotification-form").serialize()+"&HrNotification[content]="+encodeURIComponent(CKEDITOR.instances.HrNotification_content.getData())',
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Saved Successfully!");
                 $("#hr_notify_close").click();
                 reloadTable("#tbl_hrnotification_details");
            } else { 
                
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $("#hrnotification-form .hrnotification-save-btn").prop("disabled", true);                      
            $("#hrnotification-form .hrnotification-save-btn").addClass("btn_loading").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#hrnotification-form .hrnotification-save-btn").prop("disabled", false);                      
            $("#hrnotification-form .hrnotification-save-btn").addClass("btn-theme").removeClass("btn_loading"); 
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'hrnotification-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadEmployee", "function loadEmployee(){
    
  var branch = $('#HrNotification_branch').val();
var department = $('#HrNotification_department_id').val();
var designation = $('#HrNotification_designation').val();
var param = '&branch=' + branch + '&department=' + department + '&designation=' + designation;
                   $.ajax({
    url: 'index.php?r=hr/hrnotification/getemployee'+param,
  context: document.body
}).done(function(response) {

  $('#emp_id').html(response);
  $('.notifyEmp option').prop('selected', true);
  
});
           }", CClientScript::POS_HEAD);

?>
<script>
  $(document).ready(function() {  
    
        var editor = CKEDITOR.instances["HrNotification_content"];
        if (editor) { editor.destroy(true); }
        CKEDITOR.replace("HrNotification_content",
        {
             filebrowserImageUploadUrl: "js/ckeditor/filemanager/connectors/php/upload.php?Type=Image",
        });   
    });
</script>

