<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'hrnote-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">          
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->dropDownList($model,'employee_id', Employee::getEmployee(), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true)); ?>                           
            </li>
            <li class="col-sm-8">
                <?php echo $form->textArea($model, 'notes', array('data-label' => 'Notes')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="hr_note_close">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/hrnotes/Save');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Saved Successfully!");
                 $("#hr_note_close").click();
                 reloadTable("#tbl_hrnote_details");
            } else { 
                
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $("#hrnote-form .hrnote-save-btn").prop("disabled", true);                      
            $("#hrnote-form .hrnote-save-btn").addClass("btn_loading").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#hrnote-form .hrnote-save-btn").prop("disabled", false);                      
            $("#hrnote-form .hrnote-save-btn").addClass("btn-theme").removeClass("btn_loading"); 
        }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'hrnote-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget();
?>
