<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable(status)
    {
        var table_id ="#tbl_masproduct_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrmasproduct/GetList') . '",
                type: "POST",
                "data" : {
                    "status":status               
                },
                cache : false,
            },
            columns: [
                {className:"nw sl col-max-1 text-center"},
                {className:"nw sl col-max-2 "},
                {className:"nw sl col-max-6 "},
                {className:"nw sl col-max-1 text-right"},
                {className:"nw sl col-max-1 text-right"},
            ],
            order: [[ 2, "asc" ]],	
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }		
    $(document).ready(function() {  	 		
        var status = $("#product_status").val();
        filterDataTable(status);
        materializing(".material");
    });', CClientScript::POS_HEAD);
$cs->registerScript('itemdetails', 'function itemdetails(){  
        $("#tbl_masproduct_details").DataTable().destroy();
        var status = $("#product_status").val();
        filterDataTable(status); 
};', CClientScript::POS_HEAD);
$cs->registerScript("blockproduct", "function blockproduct(id,frm){
    var frm_form='';
    if(frm==1){
        frm_form='Block';
    }else if(frm==2){
        frm_form='Unblock';
    }
    var r = confirm('Are you sure to '+frm_form+' this product?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/hrmasproduct/blockproduct',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_masproduct_details');
                    t8.success('Updated Successfully!');
                }else {
                   t8.error('Error');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[5].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrmasproduct/create&id=" + datas[5].id, "Edit", "lg");
                }
            };
        }
        if (datas[5].block_button !== 0) {
            items.block = {
                name: "Block",
                icon: "fa-ban",
                callback: function () {
                      blockproduct(datas[5].id, "1");
                }
            };
        }
        if (datas[5].unblock_button !== 0) {
            items.unblock = {
                name: "Unblock",
                icon: "fa-retweet",
                callback: function () {
                      blockproduct(datas[5].id, "2");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #hrmsProductindexdropdown .material-select-label {
        display: none;
    }
    </style> 
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
         Products
        <div class="pull-right  dis-flx">
        <div class="material col-sm-12 pd-zero" id="hrmsProductindexdropdown"> 
        <span class="col-sm-3 pull-right"> 
            <?php echo CHtml::dropdownlist('product_status','Y', array('Y' => 'Available', 'N' => 'InActive'), array('empty' => 'All Products',  'title' => 'Status','data-search'=>true,'onchange' => 'itemdetails();')); ?> 
         </span>
        </div>                  
           <?php if (isset(Yii::app()->user->haveHrPermissionOn['hrmasproduct_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/hrmasproduct/create', 'Add New Item', 'xl')"><i class="fa fa-plus"></i></button>  &nbsp; -->
               <a class="ad-btn"  onclick="loadPopupModal('hr/hrmasproduct/create','Add New Item','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php 
           }
           $model_upload_mas_product = HrMasterUpload::model()->findByPK(30);
           if($model_upload_mas_product->isActive=='Y'){ 
                if (isset(Yii::app()->user->haveHrPermissionOn['hrmasproduct_upload']) || Yii::app()->user->authorised_user == 1) { ?>
                <button class="btn btn-sm btn-theme align-top-section" onclick="loadPopupModal('hr/hrmasproduct/uploadproduct', 'Upload', 'lg')"><i class="fa fa-upload"></i></button>  
               <?php }
               }
            ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_masproduct_details" style="font-size:13px;width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Product Code</th>
                        <th class="text-center">Product Name</th>
                        <th class="text-center">Cost Price</th>
                        <th class="text-center">Selling Price</th>
                    </tr>
                </thead>
                </tfoot>
            </table>
        </div>
    </div>
</section>
