<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'masproduct-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'product_code', array('data-label' => 'Product Code <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo $form->textField($model, 'product_name', array('data-label' => 'Product Name <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'cost_price', array('data-label' => 'Cost Price <span style="color:red;">*</span>','onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'selling_price', array('data-label' => 'Selling Price <span style="color:red;">*</span>')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="masproduct_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/hr/hrmasproduct/SaveProduct');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#masproduct_close").click();
                reloadTable("#tbl_masproduct_details");
            } else { 

                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#masproduct-form .masproduct-save-btn").prop("disabled", true);
            $("#masproduct-form .masproduct-save-btn").addClass("btn_loding").removeClass("btn-theme");
        }',
        'complete'=>'function(data) {
            $("#masproduct-form .masproduct-save-btn").prop("disabled", false);
            $("#masproduct-form .masproduct-save-btn").addClass("btn-theme").removeClass("btn_loding");
            $("#loader").hide();
        }',
    ), array('id' => 'mybtn' . rand(), 'class' => 'masproduct-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>










