<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'mas_course-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'course_name', array('data-label' => 'Course Name<span style="color : red;">*</span>')); ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'training_days', array('data-label' => 'Training Days','onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
        </ul>
        <div class="table-responsive">
            <table class="table table-hover table-bordered personal-task" id="course_item_table">
                <tr>
                    <th>No</th> 
                    <th>Training Detail</th>
                    <th class="text-center">
                        <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#course_item_table'));"><i class="fa fa-plus"></i></a></th>
                </tr>
                <?php           
                    foreach ($model_training as $i => $detail):                   
                ?>
                <tr>
                    <td><label><?php echo ($i+1); ?></label></td> 
                    <td>
                        <?php echo $form->hiddenField($detail, "[" . $i . "]id"); ?>
                        <?php  echo $form->textField($detail, "[" . $i . "]training_course",array('class'=>'tooltipster go', 'placeholder' => '', 'title' => 'Course')); ?>                           
                    </td>
                    <td class="text-center nw" width="1%">
                       <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removeitemRow($(\'#course_item_table\'),this,this.id)
                                           ', 'title' => 'Remove this item')); ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="mas_course_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/hrmascourse/Save');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    if(data.status=="success"){  
                                        t8.success("Details Saved Successfully!");
                                        $("#mas_course_close").click();
                                        reloadTable("#tbl_hr_mas_course");

                                    } else { 

                                        
                                        $.each(data, function(key, val) {
                                                t8.error(""+val+""); 

                                        }); 
                                    } 
                            }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#mas_course-form .mas_course-save-btn").prop("disabled", true);
                                $("#mas_course-form .mas_course-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }',
        'complete' => 'function(){
                                 $("#loader").hide();
                                $("#mas_course-form .mas_course-save-btn").prop("disabled", false);
                                $("#mas_course-form .mas_course-save-btn").addClass("btn-theme").removeClass("btn_loding");
                            }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'mas_course-save-btn btn btn-theme'));
    ?>


</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("removeitemRow", "function removeitemRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#HrMasTrainingCourseDetail_'+arr_fields+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('hr/hrmascourse/deleteCourse') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Question Deleted');
                            reloadTable('#tbl_question_details');
                        }else{
                            t8.error('Deletion Not Possible, History Exist');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);
?>