<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'asset_details_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->dropdownlist($model, 'asset_id', HrMasAsset::getAssets(), array('data-label' => 'Asset<span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'asset_detail', array('data-label' => 'Reference No <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'asset_value', array('data-label' => 'Asset Value <span style="color:red">*</span>', 'onkeypress' => 'return isPositiveInteger(event)')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'repair_cost_extra', array('data-label' => 'Repair Cost/Extra Payment', 'onkeypress' => 'return isPositiveInteger(event)')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->dropdownlist($model, 'asset_status', array('G' => 'Good', 'D' => 'Damaged'), array('data-label' => 'Status<span style="color:red">*</span>', 'onchange' => 'GetAvailability();')); ?>
            </li>
            <li class="col-sm-2" id="div_availability">
                <?php
                echo $form->dropdownlist($model, 'availability_status', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Availability<span style="color:red">*</span>', 'onchange' => 'checkavailability(this.value);'));
                ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="asset_details_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/Hrmasassetdetails/SaveEditDetails');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){  

                     t8.success("Details Saved Successfully!");

                     $("#asset_details_close").click();
                    reloadTable("#assetdetails_table");

                } else { 

                    $("#asset_details_form .asset-details-save-btn").prop("disabled", false);
                    $("#asset_details_form .asset-details-save-btn").addClass("btn-theme").removeClass("btn_loding");
                    $.each(data, function(key, val) {
                            t8.error(""+val+""); 

                    }); 

                } 

        }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#asset_details_form .asset-details-save-btn").prop("disabled", true);
                                $("#asset_details_form .asset-details-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'asset-details-save-btn btn btn-theme'));
    ?>


</div>


<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("GetAvailability", " function GetAvailability() {
    var status_id = $('#HrMasAssetDetails_asset_status').val();
    if(status_id=='D')
    {
        $('#HrMasAssetDetails_availability_status').multiselect('select', 'N');
        $('#HrMasAssetDetails_availability_status').multiselect('refresh');
    }else{
        checkavailability('Y');
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("checkavailability", " function checkavailability(availability) {
    if(availability=='Y'){
        var id = $('#HrMasAssetDetails_id').val();
        jQuery.ajax({
            'dataType':'json', 
            'type': 'post',
             'url': '" . Yii::app()->createUrl('hr/Hrmasassetdetails/getAvailability') . "',
             'data' :{'id':id},
            'cache': false,
            'success': function(data) {
                if(data.status=='success'){
                    t8.error('Already allocated to employee!');
                    $('#HrMasAssetDetails_availability_status').multiselect('select', data.available);
                    $('#HrMasAssetDetails_availability_status').multiselect('refresh');
                }
                else
                {
                    t8.error('Already allocated to employee!');
                    $('#HrMasAssetDetails_availability_status').multiselect('select', data.available);
                    $('#HrMasAssetDetails_availability_status').multiselect('refresh');
                }
            },
            'beforeSend':function(){
             $('#loader').show();
            },
           'complete':function(){
               $('#loader').hide();
           }
        });
    }
}", CClientScript::POS_HEAD);








