<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", '
        $(document).ready(function() {
        var table_id ="#tbl_expense_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            aoColumnDefs: [
              { "bSortable": false, "aTargets": [ 5,6,7,8 ] },
            ],
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrexpense/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
$cs->registerScript("deleteexpense", "function deleteexpense(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=hr/hrexpense/deleteexpense',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_expense_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[9].edit_btn !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrexpense/create&id="+datas[9].id, "Edit Expense Detail", "xl");
                }
            };
        }
        if (datas[9].delete_btn !== 0) {
            items.Delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                     deleteexpense(datas[9].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        Expense
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_expense_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <a class="ad-btn" onclick="loadPopupModal('hr/hrexpense/create', 'Add Expense', 'xl')" title="Add">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_expense_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee</th>      
                        <th>Title</th>
                        <th>Start</th>
                        <th>Validity Month</th>
                        <th>Amount/Month</th>
                        <th>Paid Amount</th>
                        <th>Balance Amount</th>
                        <th>Total Amount</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
