<?php
$current_date = date('Y-m-d');
$model_notice->month = str_pad($model_notice->month, 2, '0', STR_PAD_LEFT);
$month_name = HrGenerelSettings::getMonthName($model_notice->month);
$branch_id = $model_notice->employeedetail->branch_or_sponsor_id;
$model_pdf_settings = DocumentSettings::model()->find();
$company_name = "";
$company_address = "";
$company_phno = "";
$company_web_address = "";
if (!empty($model_pdf_settings)) {
    $company_name = strtoupper($model_pdf_settings->company_name);
    $company_address = $model_pdf_settings->company_address;
    $company_phno = $model_pdf_settings->company_phno;
    $web = substr($model_pdf_settings->company_web_address, 0, 3);
    if ($web != 'www') {
        $company_web_address = 'www.';
    }
    $company_web_address .= $model_pdf_settings->company_web_address;
} else {
    $model_company = MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id);
    $company_name = strtoupper($model_company->company_name);
    $company_address = $model_company->billing_address;
    $company_phno = $model_company->genral_phno;
    $web = substr($model_company->genral_web, 0, 2);
    if ($web != 'www') {
        $company_web_address = 'www.';
    }
    $company_web_address = $model_company->genral_web;
}
if ($branch_id != '') {
    $model_branch = MasCompanyBranchSponsor::model()->findByPK($branch_id);
    if ($model_branch->slip_header_name != '') {
        $company_name = $model_branch->slip_header_name;
    }
    if ($model_branch->branch_or_sponsor_address != '') {
        $company_address = $model_branch->branch_or_sponsor_address;
    }
    if ($model_branch->branch_or_sponsor_phno != '') {
        $company_phno = $model_branch->branch_or_sponsor_phno;
    }
    if ($model_branch->branch_or_sponsor_web != '') {
        $company_web_address = $model_branch->branch_or_sponsor_web;
    }
}
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Warning Letter</title>
    </head>
    <body>
        <?php
            $this->renderPartial('/common/header', array('branch_id' => $branch_id));
        ?>
        <div class="clearfix"></div>

        <div style="width: 90%; margin: 0 auto; font-family: Space Grotesk;">
            <div class="">
                <div style="text-align: center;">
                    <h2>Warning Letter</h2>
                </div>
             <table style="width: 100%; border-collapse: collapse; text-align: left;">
  <tr>
    <td style="padding: 4px 8px; width: 30%;"><strong>Code/Ref/Year:</strong></td>
    <td style="padding: 4px 8px;">
      <?php echo $model_master_certificate->code . '/' . $ref_no . '/' . date('Y'); ?>
    </td>
  </tr>
  <tr>
    <td style="padding: 4px 8px;"><strong>Date:</strong></td>
    <td style="padding: 4px 8px;">
      <?php echo date("d/m/Y"); ?>
    </td>
  </tr>
  <tr>
    <td style="padding: 4px 8px; vertical-align: top;"><strong>To:</strong></td>
    <td style="padding: 4px 8px;line-height: 25px;">
      <?php echo $model_notice->employeedetail->employeefullname; ?><br>
      <?php echo $model_notice->employeedetail->designationdetail->designation_name; ?><br>
      <?php echo $model_notice->employeedetail->employeecode; ?>
    </td>
  </tr>
</table>

                <div style="text-align: left;">
                    <p><b>Subject: <?php echo $model_notice->subject; ?></b></p>
                </div>   
                <div style="text-align: left;">
                    Dear <?php echo $model_notice->employeedetail->employeefullname; ?>,
                </div>
                <div style="text-align: justify;">
                    <p>This is to inform that the management has taken notice of the recent <?php echo $model_notice->warning_field_1; ?>.</p>
                    <p>Kindly note that this is unacceptable as per our company policy. You are requested <?php echo $model_notice->warning_field_2; ?>.</p>
                    <p>The following is served as a <?php echo $model_notice->employeedetail->designationdetail->designation_name; ?>. Kindly ensure that there is a significant improvement in your performance, or it may lead to further disciplinary action.</p>
                </div>
                <div>       
                    <br>
                    <?php
                    foreach ($signature as $value) {
                        echo '<p>' . $value . '</p>';
                    }
                    ?> 
                    <br><br>
                    <br>
                    <?php echo $model_notice->employeedetail->employeefullname; ?>

                </div>

            </div>
        </div>
        <br>
        <?php
        $this->renderPartial('/common/footer');
        ?>

    </body>
</html>