<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable()
    {
        var table_id ="#tbl_doc_template_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
            pageLength      : 50,
            processing: true,    
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrcompanytemplate/GetList') . '",
                type: "POST",
                cache : false,
            },
           
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
            
        });
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	 	
        filterDataTable(); 
    });', CClientScript::POS_HEAD);
$cs->registerScript("deletetemplate", "function deletetemplate(id){
    var r = confirm('Are you sure want to delete this template?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/hrcompanytemplate/deletetemplate',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_doc_template_details');
                    t8.success('Deleted SuccessFully!');
                }else {
                   t8.error('Error');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) { 
        let items = {};
        if (datas[3].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrcompanytemplate/create&id="+ datas[3].id, "Edit Template ", "lg");
                }
            };
        }
        if (datas[3].delete_button !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                    deletetemplate(datas[3].id);
                }
            };
        }
        if (datas[3].download_button !== 0) {
            items.cancel = {
                name: "Download",
                icon: "fa-remove",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/hrcompanytemplate/downloadtemplate&id=" + datas[3].id, "_blank");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        Document Template
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_template_add']) || Yii::app()->user->authorised_user == 1) { ?>
             <a class="ad-btn"  onclick="loadPopupModal('hr/hrcompanytemplate/create', 'Document Template', 'lg')" title="Add Document Template">                
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_doc_template_details" style="font-size:13px;width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Branch</th>
                        <th class="text-center">Document</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
