<!DOCTYPE html>
<html>

    <head>
        <title>End Of Service Details</title>
        <style>

            @page {
                margin-top: 3.6cm;
                margin-bottom: 3.5cm;
                margin-left: 1cm;
                margin-right: 1cm;
                header: html_myHeader;
                header: html_otherpages;
                footer: html_firstfooter;
                font-family:'Times New Roman';
            }
            @page :first {
                margin-top: 3.6cm;
                margin-bottom: 3cm;
                header: html_firstpage;
                footer: html_firstfooter;
            }
            @page :last {
                footer: html_lastfooter;
            }
            .table-responsive th{
                text-align: center;
                border: 1px solid  #D1D2D4;
                border-color:  #458ec3;
            }
            .table-responsive td{
                border: 1px solid #3b3d40;
                border-color:  #458ec3;
            }
        </style>
    </head>

    <body>
        <?php
        $model = EmployeeEOS::model()->findbyPK($id);
        $model_asset = EmployeeAsset::model()->findAll(array('condition' => 'employee_id="' . $model->employee_id . '"'));
        $model_eos_details = EmployeeEOSDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
        $model_eos_gratuity_details = EosGratuityDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"', 'order' => 'id asc'));
        $model_eos_clearance = EmployeeEosClearanceDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
        $model_branch = MasCompanyBranchSponsor::model()->findByPK($model->employeedetail->branch_or_sponsor_id);
        if ($model_branch->slip_header_name != '') {
            $company_name = $model_branch->slip_header_name;
        }
        if ($model_branch->branch_or_sponsor_address != '') {
            $company_address = $model_branch->branch_or_sponsor_address;
        }
        if ($model_branch->branch_or_sponsor_phno != '') {
            $company_phno = $model_branch->branch_or_sponsor_phno;
        }
        if ($model_branch->branch_or_sponsor_web != '') {
            $company_web_address = $model_branch->branch_or_sponsor_web;
        }
        $eos_releaving_type = array('1' => 'Termination', '2' => 'Resignation', '3' => 'Retirement');
        $currency = $model->employeedetail->currencydetails->currency_code;
        ?>
    <htmlpageheader name="firstpage" style="display:none">
        <?php
        $this->renderPartial('/common/header', array('branch_id' => $model->employeedetail->branch_or_sponsor_id));
        ?>
    </htmlpageheader>
    <htmlpageheader name="otherpages" style="display:none">
        <?php
        $this->renderPartial('/common/header', array('branch_id' => $model->employeedetail->branch_or_sponsor_id));
        ?>
    </htmlpageheader>
        <sethtmlpageheader name="firstpage" value="off" show-this-page="1" />
        <sethtmlpageheader name="otherpages" value="on" />
        <div class="clearfix"></div>
        <div class="table-responsive">
            <div class="panel-heading panel-theame" style="margin-top: -12px; margin-bottom: -15px; border-color: #458ec3;">
                <h4 style="text-align: center"> END OF SERVICE</h4>
            </div>
            <table class="table table-bordered personal-task" style="font-size:10px;">
                <tbody>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Employee Code</b></td>
                        <td class="text-right">
                            <?php
                            echo $model->employeedetail->employeecode;
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Employee Name</b></td>
                        <td class="text-right" style="background-color: #fff;">
                            <?php
                            echo $model->employeedetail->employeefullname;
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Joining Date</b></td>
                        <td class="text-right text-bold">
                            <?php
                            if ($model->employeedetail->date_join != '' && $model->employeedetail->date_join != '0000-00-00') {
                                echo date("d/m/Y", strtotime($model->employeedetail->date_join));
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Department</b></td>
                        <td class="text-right" style="background-color: #fff;">
                            <?php
                            echo $model->employeedetail->departmentdetail->department_name;
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Designation</b></td>
                        <td class="text-right">
                            <?php
                            echo $model->employeedetail->designationdetail->designation_name;
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Last Day of Work</b></td>
                        <td class="text-right" style="background-color: #fff;">
                            <?php
                            if ($model->date_leaving != '' && $model->date_leaving != '0000-00-00') {
                                echo date("d/m/Y", strtotime($model->date_leaving));
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Completed Period</b></td>
                        <td class="text-right text-bold">
                            <?php
                            $d1 = strtotime($model->employeedetail->date_join);
                            $d2 = strtotime($model->date_leaving);
                            $datediff = $d2 - $d1;
                            $service_days = $datediff / (60 * 60 * 24) + 1;
                            $date1 = new DateTime($model->employeedetail->date_join);
                            $date2 = new DateTime($model->date_leaving);
                            $dd = date_diff($date1, $date2);
                            $dayss = 'Day';
                            if ($dd->d > 1) {
                                $dayss = 'Days';
                            }
                            $service_period = "$dd->y Yrs $dd->m Month $dd->d $dayss";
                            echo $service_days . ' days - ' . $service_period;
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Releaving Type</b></td>
                        <td class="text-right" style="background-color: #fff;"><?php echo $eos_releaving_type[$model->releaving_type]; ?></td>
                    </tr>
                    <tr>
                        <td style="background-color: #d6e2ef; "><b>Gratuity Rule</b></td>
                        <td class="text-right"><?php echo $model->gratuityrule->rule_type; ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <?php
        $model_salary_details = EmployeeSalary::model()->findAll(array('condition' => 'employee_id="' . $model->employee_id . '" AND (("' . $model->date_leaving . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $model->date_leaving . '" AND valid_to="0000-00-00")) AND isActive="Y"'));
        ?>
        <div class="table-responsive">
            <table class="table table-fixed table-primary" style="font-size:10px;">
                <tbody>
                    <tr style="border:none;"><td colspan="2"></td></tr>
                    <?php
                    $total_salry = 0.00;
                    foreach ($model_salary_details as $key => $value) {
                        $total_salry += $value->amount;
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b><?php echo $value->salary->salary_name; ?></b></td>
                            <td class="text-right text-bold" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($value->amount, "");
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Total Salary</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;"><b>
                                <?php echo Yii::app()->numberFormatter->formatCurrency($total_salry, "");
                                ?></b>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" class="bg-imp text-right" style="background: #458ec3;">
                            <b> <?php echo $currency . " " . ucfirst($this->widget('ext.NumtoWord.NumtoWord', array('num' => floatval($total_salry)))->result) . ' Only'; ?></b>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="table-responsive">
            <table class="table table-fixed table-primary" style="font-size:10px;">
                <tr>
                    <th class="heady" style="text-align:center; border: none;" colspan="2">ADDITIONS</th>
                </tr>
                <tbody>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Leave Encashed</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($model->leave_settlement, "");
                            ?>
                        </td>
                    </tr>
                    <?php
                    if ($model->overtime_salary > 0) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b>Overtime Amount</b></td>
                            <td class="text-right text-bold" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->overtime_salary, "");
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Salary Pending</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($model->employee_salary, "");
                            ?>
                        </td>
                    </tr>
                    <tr style="border:none;"><td colspan="2"></td></tr>
                </tbody>
                <tr>
                    <th  style="text-align:center; border: none;" colspan="2">GRATUITY PER YEAR</th>
                </tr>
            </table>
            <table class="table table-fixed table-primary" style="font-size:10px;">
                <tbody>
                    <?php
                    foreach ($model_eos_gratuity_details as $key => $each_year_value) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><?php echo $each_year_value->payment_period ?></td>
                            <td class="text-right" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($each_year_value->amount, "");
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    <tr style="border:none;"><td colspan="2"></td></tr>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Gratuity</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($model->gratuity, "");
                            ?>
                        </td>
                    </tr>
                    <?php
                    if ($model->notice_period_salary > 0) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b>Notice Period Salary</b></td>
                            <td class="text-right text-bold" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->notice_period_salary, "");
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Other Additions</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($model->addition_others, "");
                            ?>
                        </td>
                    </tr>
                    <?php
                    $model_addition = EmployeeEosPayment::model()->with('paymentdetail')->findAll(array('condition' => 'eos_id="' . $id . '" and paymentdetail.type="A"'));

                    foreach ($model_addition as $key => $addition) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b><?php echo $addition->paymentdetail->payment_name ?></b></td>
                            <td class="text-right" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($addition->amount, "");
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    <tr>
                        <td style="background-color: #458ec3; width: 50%"><b>Total Additions</b></td>
                        <td class="text-right text-bold" style="background-color: #458ec3;"><b>
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->additions, "");
                                ?></b>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="table-responsive">
            <table class="table table-fixed table-primary" style="font-size:10px;">
                <tr><th style="text-align:center; border: none" colspan="2">DEDUCTIONS</th></tr>
                <tbody>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Leave Amount</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($model->leave_amount, "");
                            ?>
                        </td>
                    </tr>
                    <?php
                    if ($model->loan > 0) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b>Loan</b></td>
                            <td class="text-right text-bold" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->loan, "");
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    if ($model->salary_advance > 0) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b>Salary Advance</b></td>
                            <td class="text-right text-bold" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->salary_advance, "");
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    if ($model->pension_amount > 0) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b>Pension Amount(Employee %)</b></td>
                            <td class="text-right text-bold" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->pension_amount, "");
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td style="background-color: #d6e2ef; width: 50%"><b>Other Deductions</b></td>
                        <td class="text-right text-bold" style="background-color: #fff;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($model->deduction_others, "");
                            ?>
                        </td>
                    </tr>
                    <tr style="border:none;"><td colspan="2"></td></tr>
                </tbody>
            </table>
            <table class="table table-fixed table-primary" style="font-size:10px;">
                <tbody>
                    <?php
                    $model_deduction = EmployeeEosPayment::model()->with('paymentdetail')->findAll(array('condition' => 'eos_id="' . $id . '" and paymentdetail.type="D"'));

                    foreach ($model_deduction as $key => $deduction) {
                        ?>
                        <tr>
                            <td style="background-color: #d6e2ef; width: 50%"><b><?php echo $deduction->paymentdetail->payment_name ?></b></td>
                            <td class="text-right" style="background-color: #fff;">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($deduction->amount, "");
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    <tr>
                        <td style="background-color: #458ec3; width: 50%"><b>Total Deductions</b></td>
                        <td class="text-right text-bold" style="background-color: #458ec3;"><b>
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->deductions, "");
                                ?></b>
                        </td>
                    </tr>
                    <tr style="border:none;"><td colspan="2"></td></tr>
                    <tr>
                        <td style="background-color: #458ec3; width: 50%"><b>NET PAYABLE</b></td>
                        <td class="text-right text-bold" style="background-color: #458ec3;"><b>
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->total_amount, "");
                                ?></b>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <?php if (!empty($model_asset)): ?>
            <div class="table-responsive">
                <table class="table table-fixed table-primary" style="font-size:10px;">
                    <tr>
                        <th class="" style="text-align:center; border:none" colspan="3">ASSETS</th>
                    </tr>
                    <thead>
                        <tr>
                            <th class="text-center">Asset</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Return Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $arr_asset_status = array(1 => 'Issued', 2 => 'Returned', 3 => 'Discarded', 4 => 'Lost');
                        foreach ($model_asset as $key => $asset_value) {
                            ?>
                            <tr>
                                <td style="background-color: #fff;"><b><?php echo $asset_value->assetdetails->asset_detail; ?></b></td>
                                <td class="text-center" style="background-color: #fff;"><?php echo $arr_asset_status[$asset_value->asset_status]; ?></td>
                                <td class="text-center" style="background-color: #fff;"><?php
                                    if ($asset_value->asset_date_return != '' && $asset_value->asset_date_return != '0000-00-00') {
                                        echo date("d/m/Y", strtotime($asset_value->asset_date_return));
                                    }
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
        <?php
        $model_hr_settings = HrGenerelSettings::model()->find();
        if ($model_hr_settings->eos_clearance == 'N') {
        if (!empty($model_eos_clearance)): ?>
            <div class="table-responsive">
                <table class="table table-fixed table-primary" style="font-size:10px;">
                    <tr>
                        <th class="" style="text-align:center; border:none" colspan="2">CLEARANCE</th>
                    </tr>
                    <thead>
                        <tr>
                            <th class="text-center">Document</th>
                            <th class="text-center">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $arr_clearance_status = array(1 => 'Cleared', 2 => 'Not Cleared');
                        foreach ($model_eos_clearance as $key => $clearance) {
                            ?>
                            <tr>
                                <td style="background-color: #fff;"><?php echo $clearance->eos_clearance->clearance_name; ?></td>
                                <td class="text-center" style="background-color: #fff;"><?php echo $arr_clearance_status[$clearance->clearance_status]; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        <?php endif; 
        } ?>
        <div style="margin-top: 17px;">
            <table style="table-layout: fixed; width: 100%; font-size: 10px;">
                <tr>
                    <td style="width: 50%">___________________________________________</td>
                    <td style="width: 50%; text-align: right;">___________________________________________</td>
                </tr>
                <tr>
                    <td style="width: 50%; text-align: left;">Prepared By</td>
                    <td style="width: 50%; text-align: left;padding-left: 162px;">Approved By</td>
                </tr>
            </table>
        </div>
        <div>
            <p style="font-size:10px;"><b>I have received all my dues and final settlement from the company.</b></p>
            <p>______________________________</p>
            <p style="font-size:10px;"><?php echo $model->employeedetail->employeefullname; ?></p>
            <p style="margin-top: -5px; font-size:10px;"><?php echo date('d/m/Y'); ?></p>
        </div>
    <!--    <p><b>I have received all my dues and final settlement from the company.</b></p>
        <p>______________________________</p>
        <p><?php // echo $model->employeedetail->employeefullname;      ?></p>
        <p style="margin-top: -3px;"><?php // echo date('d/m/Y');      ?></p>-->

    </body>
</html>
