<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadticketdetails", '
    function filterDataTable(employee_id,status,year) {
        var table_id ="#tbl_employeeticket_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            columns: [           
                {className: "" },
                {className: ""},
                {className: "" },
                {className: ""}, 
                {className: ""}, 
                {className: "text-right"}, 
                {className: ""}, 
                {className: ""},
                
            ],
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/employeetickets/GetEmployeeticketList') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "status" : status,
                    "year" : year                    
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
                        processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	  
        var employee_id= $("#ticket_employee_id").val();
        var status  = $("#ticket_status").val();
        var year = $("#ticket_year").val();		
        filterDataTable(employee_id,status,year);
         materializing(".material"); 
    })
	
	', CClientScript::POS_HEAD);
$cs->registerScript("ticketdetails",  "function ticketdetails(){  
    $('#tbl_employeeticket_details').DataTable().destroy();
    var employee_id       = $('#ticket_employee_id').val();	
    var status  = $('#ticket_status').val();
    var year        = $('#ticket_year').val();
    filterDataTable(employee_id,status,year);
   
};", CClientScript::POS_HEAD); 
?>
<style>
    #employeeticketindexdropdown .material-select-label {
        display: none;
    }
    </style>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
       
        if (datas[8].approve_reject !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/employeetickets/approverequest&id=" + datas[8].id, "Employee Tickets", "lg");
                }
            };
        }
        
        if (datas[8].ticket_print !== 0) {
            items.print = {
                name: "Approval Document",
                icon: "fa-print",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/employeetickets/ticketapprovaldocument&id=" + datas[8].id, "_blank")
                }
            };
        }
        if (datas[8].ticket_approval_download !== 0) {
            items.print = {
                name: "Download Approval Document",
                icon: "fa-download",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/employeetickets/downloadticketapprovaldocument&id=" + datas[8].id, "_blank")
                }
            };
        }
        if (datas[8].ticket_view !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                     loadPopupModal("hr/employeetickets/viewticketdetails&id=" + datas[8].id, "Employee Ticket Encashment", "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">Employee Tickets
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeticketindexdropdown"> 
            <span class="col-sm-3 pull-right"> 
           <?php echo CHtml::dropdownlist('ticket_year',date("Y"),HrGenerelSettings::listYears(4,0),  array('class'=>'col-sm-3 form-control_1','title' => 'Year','data-search'=>true,'onchange'=>'ticketdetails();')); ?>  &nbsp;
           </span>    
           <span class="col-sm-3 pull-right"> 
            <?php
            echo CHtml::dropdownlist('ticket_status',1,array(
                        '1' => 'Applied',
                        '2' => 'Approved', 
                        '3' => 'Rejected', 
                        '4' => 'Payment Released'
                ),  array('title' => 'Please select Status','data-search'=>true,'onchange'=>'ticketdetails();','multiple'=>true)); 
            ?>
            </span>
            
            <span class="col-sm-3 pull-right">         
            <?php echo CHtml::dropDownList("ticket_employee_id",'',Employee::gettktEmployee(), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'ticketdetails();')); ?>  
           </span>
            </div>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <a class="ad-btn" style="position: relative;top: 4px;" title="Add" onclick="loadPopupModal('hr/employeetickets/applyticket','Ticket','xl')">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_employeeticket_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Applied Date</th>
                            <th>Approved Date</th>
                            <th>Ticket Amount</th>  
                            <th>Year</th>  
                            <th>Status</th>  
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </section>
