<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'ticket_request-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
               <?php
                echo $form->dropDownList($model,'employee_id', Employee::gettktEmployee(), array('empty' => 'Select', 'data-label' => 'Employee Name','data-search'=>'true','onchange'=>'getbranchleave(this.value)'));
                ?>  
            </li>
            <li class="col-sm-3" id="li_leave_master_ticket">
               <?php
                echo $form->dropDownList($model,'leave_type', array(), array('empty' => 'Select', 'data-label' => 'Leave Type','data-search'=>'true'));
                ?>  
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model, 'year',HrGenerelSettings::listYears(1,0), array('empty' => 'Select','data-label' => 'Year','onchange'=>'tktdetails(this.value);')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'ticket_amt', array('data-label' => 'Ticket Amount','onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
        </ul>

    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="ticket_close_2" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="btn_apply_ticket_encash_1" onclick="saveticketdetails();" style="display: none;">Save</button>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("getbranchleave", "function getbranchleave(id){  
        jQuery.ajax({
           'dataType':'json',
            'data' : {'id':id},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/employeetickets/getbranchleave') . "',
            'success': function(data) {
                $('#li_leave_master_ticket').html(data.leave);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);
$cs->registerScript('saveticketdetails', 'function saveticketdetails(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#ticket_request-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hr/employeetickets/saveticketdetails') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Details Saved Successfully!");
                $("#ticket_close_2").click();
                reloadTable("#tbl_employeeticket_details");
            } else { 
               $.each(data, function(key, val) {
                       t8.error(""+val+""); 
               }); 
            } 
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
$cs->registerScript("tktdetails", "function tktdetails(year){
    var id= $('#EmployeeTicket_employee_id').val();
    var leavetype= $('#EmployeeTicket_leave_type').val();
        jQuery.ajax({
            'dataType':'json',
            'data' : {'id':id,'leavetype':leavetype,'year':year},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/employeetickets/getticketencashed') . "',
            'success': function(data) {
                if(data.status=='success'){
                    $('#btn_apply_ticket_encash_1').show();
                }else{
                    t8.error('Ticket already encashed');
                }
            }
        });
 }
", CClientScript::POS_HEAD);
?>








