<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'ticket_request-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
               <?php
                echo $form->dropDownList($model,'employee_id', Employee::getemployee(), array('empty' => 'Select', 'data-label' => 'Employee Name','data-search'=>'true','onchange'=>'tktdetails();'));
                ?>  
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropdownlist($model, 'year',HrGenerelSettings::listYears(1,0), array('empty' => 'Select','data-label' => 'Year','onchange'=>'tktdetails();')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'ticket_amt', array('data-label' => 'Ticket Amount','onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'travel_date',array('class' => 'datepicker','title' => 'Date of Journey','data-label'=>'Date of Journey', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'travel_destination',array('class' => 'tooltipster','title' => 'Destination','data-label'=>'Destination')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'return_date',array('class' => 'datepicker','title' => 'Return Date','data-label'=>'Return Date', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'return_destination',array('class' => 'tooltipster','title' => 'Return Destination','data-label'=>'Return Destination')); ?>
            </li>
            <li class="col-sm-12">
               <?php
                echo $form->textArea($model,'family_member', array('data-label' => 'Family Members'));
                ?>  
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="ticket_close_2" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="btn_apply_ticket_encash_1" onclick="saveflyticketdetails();" style="display: none;">Save</button>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript('saveflyticketdetails', 'function saveflyticketdetails(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#ticket_request-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hr/employeetickets/saveflyticketdetails') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Details Saved Successfully!");
                $("#ticket_close_2").click();
                reloadTable("#tbl_employeeflyticket_details");
            } else { 
               $.each(data, function(key, val) {
                       t8.error(""+val+""); 
               }); 
            } 
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
$cs->registerScript("tktdetails", "function tktdetails(year){
      $('.toast8-error').hide(); 
    var id= $('#EmployeeTicket_employee_id').val();
    var year=$('#EmployeeTicket_year').val();
    if(id!='' && year!=''){
        jQuery.ajax({
            'dataType':'json',
            'data' : {'id':id,'year':year},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/employeetickets/checkfamilyticket') . "',
            'success': function(data) {
                if(data.status=='success'){
                    $('#btn_apply_ticket_encash_1').show();
                }else if(data.status=='notprovided'){
                    t8.error('Ticket Not Provided');
                }else if(data.status=='notavailable'){
                    t8.error('Ticket Not Provided by Company');
                }else{
                    t8.error('Family Ticket already taken');
                }
            }
        });
    }
 }
", CClientScript::POS_HEAD);
?>








