<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        List of Employee Loans
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable html_table">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw">No</th>
                        <th class="text-center tbl-iw nw">Branch</th>
                        <th class="text-center tbl-iw nw">Code</th>                    
                        <th class="text-center tbl-iw nw">Name</th>        
                        <th class="text-center tbl-iw nw">Loan Amount</th>                                       
                        <th class="text-center tbl-iw nw">No of Inst</th>  
                        <th class="text-center tbl-iw nw">Monthly Inst</th>
                        <th class="text-center tbl-iw nw">Repayment Start</th>
                        <th class="text-center tbl-iw nw">Approved Date</th>  
                        <th class="text-center tbl-iw nw">Payment Date</th>  
                        <th class="text-center tbl-iw nw">Pending Amount</th>
                        <th class="text-center tbl-iw nw">Status</th>
                </thead>
                <tbody>
                    <?php
                    $condition = "1=1";
                    if ($employee_id != '') {
                        $condition .= ' AND employee_id= "' . $employee_id . '"';
                    }
                    if ($branch_id != '') {
                        $condition .= ' AND employeedetail.branch_or_sponsor_id= "' . $branch_id . '"';
                    }
                    if ($status != '') {
                        $condition .= ' AND loan_status = "' . $status . '"';
                    }
                    if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                        $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
                    }

                 $model_loan=EmployeeLoanDetail::model()->with('employeedetail')->findAll(array('condition' => $condition)); 

                    foreach ($model_loan as $j => $loan_detail) {
                        ?>
                        <tr>
                            <td class="text-left tbl-iw nw"><?php echo $j + 1; ?></td>
                            <td class="text-left tbl-iw nw"><?php echo $loan_detail->employeedetail->branch_sponsor->branch_or_sponsor_name; ?></td>
                            <td class="text-left tbl-iw nw"><?php echo $loan_detail->employeedetail->employeecode; ?></td>
                            <td class="text-left tbl-iw nw"><?php echo$loan_detail->employeedetail->employeefullname; ?></td>
                            <td class="text-right tbl-iw nw"><?php echo Yii::app()->numberFormatter->formatCurrency($loan_detail->loan_amount,""); ?></td>  
                            <td class="text-center tbl-iw nw"><?php echo $loan_detail->loan_total_installment; ?></td>  
                            <td class="text-right tbl-iw nw"><?php echo Yii::app()->numberFormatter->formatCurrency($loan_detail->loan_monthly_payment,""); ?></td>  
                            <td class="text-right tbl-iw nw"><?php if($loan_detail->repayment_start_year>0){ echo HrGenerelSettings::getMonthName1($loan_detail->repayment_start_month)." ". $loan_detail->repayment_start_year; }?></td> 
                            <td class="text-center tbl-iw nw"><?php 
                                $loandate='';												
                                if($loan_detail->approved_date!= '0000-00-00' && $loan_detail->approved_date!= ''){
                                    $loandate = date("d/m/Y", strtotime($loan_detail->approved_date));
                                }
                                echo $loandate;
                            ?></td>
                            <td class="text-center tbl-iw nw"><?php 												
                                if($loan_detail->payment_date!= '0000-00-00' && $loan_detail->payment_date!= ''){
                                    echo date("d/m/Y", strtotime($loan_detail->payment_date));
                                }
                            ?></td>
                            <td class="text-right tbl-iw nw"><?php echo Yii::app()->numberFormatter->formatCurrency(($loan_detail->loan_amount-$loan_detail->loan_repayment),""); ?></td>  
                            <td class="text-left tbl-iw nw"><?php echo EmployeeLoanDetail::getLoanStatus($loan_detail->loan_status); ?></td>                    
                        </tr>
                        <?php } ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php //echo CHtml::link('Export PDF', array('hr/reports/PrintEmployeeLoanReportPDF', 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), array('title' => 'Print Loan List', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <!--<button type="button" class="btn btn-theme" onclick="excelEmployee_loanList();">Export Excel</button>	-->		  
            </div>
        </div>
    </div>
</div>
</div><?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("excelEmployee_loanList", "function excelEmployee_loanList(){    
    var branch_id = $('#hr_report_branch_id_loan').val();   
    var employee_id = $('#hr_report_employee_id_loan').val();    
    var status = $('#hrreport_loan_status_id').val();   
    window.open($('#liveSite').val()+'index.php?r=hr/excel/PrintEmployeeLoanExcel&branch_id='+branch_id+'&employee_id='+employee_id+'&status='+status, '_blank');
}", CClientScript::POS_HEAD);
