<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadBank", '
        $(document).ready(function() {

        var table_id ="#tbl_emp_geocode_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/Employeegeocode/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
             "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            
              if ( aData[4].status == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                }      
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[4].edit !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                loadPopupModal("hr/Employeegeocode/edit&id=" + datas[4].id, "Edit", "lg");
                }
            };
        }
        if (datas[4].delete !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                DeleteCode(datas[4].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
            selector: 'td',
                items: items
            });
        }
    }
    function DeleteCode(id){
        var r = confirm('Are you sure to delete this?');
        if (r == true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'datatype' :'json',
                'data'  : 'id=' + id,
                'url'  : $('#liveSite').val() + 'index.php?r=hr/Employeegeocode/deleteemployeegeocode',
                'cache': false,
                'success':function(data){
                    if (data.status == 'error'){
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_emp_geocode_details').DataTable().ajax.reload()
                        t8.success('Deleted SuccessFully!');
                    }
                }
            });
        }
    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Employee Geocode
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_geocode_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/Employeegeocode/create', 'Add New Employee Geocode', 'lg')"><i class="fa fa-plus"></i></button> -->
            <a class="ad-btn"  onclick="loadPopupModal('hr/Employeegeocode/create','Add New Employee Geocode','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_emp_geocode_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Name</th>
                        <th>Geocode Location</th>

                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
