<?php
// Get the logged-in user's ID
$model_user = User::model()->findbypk(Yii::app()->user->id);
$loggedInUserId = $model_user->employee_id;

// Fetch the employees who are active
$employees = Employee::model()->with('designationdetail')->findAll('t.isActive = :isActive', array(':isActive' => 'Y'));

// Initialize variables for employee hierarchy
$employeeHierarchy = [];

// Loop through each employee to organize the hierarchy
foreach ($employees as $employee) {
    // If the employee has a reporting manager, add them to the hierarchy
    if ($employee->reporting_manager) {
        $employeeHierarchy[$employee->reporting_manager][] = $employee;
    }
}

// Function to display the employees and their hierarchy
function display_employee_tree($employeeHierarchy, $managerId, $visitedEmployees = [], $loggedInUserId) {
    // Check if the current manager has subordinates
    if (isset($employeeHierarchy[$managerId])) {
        // Start the list for this manager's subordinates
        echo '<ul>';

        // Loop through each subordinate under the current manager
        foreach ($employeeHierarchy[$managerId] as $employee) {
            // Skip the logged-in user and already visited employees
            if (in_array($employee->id, $visitedEmployees) || $employee->id == $loggedInUserId) {
                continue;
            }

            // Mark the employee as visited to prevent showing them again
            $visitedEmployees[] = $employee->id;

            // Display the employee's name and designation as a list item
            echo '<li><img src="uploads/profilephotos/' . (!empty($employee->profile_photo) ? $employee->profile_photo : 'emp.jpg') . '" width="50px" height="50px">  
            <a href="#">' . CHtml::encode($employee->de_first_name) . ' ( ' . CHtml::encode($employee->designationdetail->designation_name) . ' / ' . $employee->hr_code . ' )</a>';

            // If this employee is the logged-in user, display their subordinates
            if ($employee->id == $loggedInUserId) {
                // Display subordinates of the logged-in user
                display_employee_tree($employeeHierarchy, $employee->id, $visitedEmployees, $loggedInUserId);
            }

            // Recursively call the function for the subordinates of this employee
            display_employee_tree($employeeHierarchy, $employee->id, $visitedEmployees, $loggedInUserId);

            // Close the list item for this employee
            echo '</li>';
        }

        // Close the current manager's list of subordinates
        echo '</ul>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Horizontal Organization Chart</title>
    <style>
        .tree ul li img { border-radius: 50%; }
        .tree li img { border-radius: 50%; }
        .tree > li{min-height: 800px;margin-left:10%;background:none !important;}
    </style>
</head>
<body>
    <section class="panel" style="background-color:#F6F3EE; font-size: 10px;">
        <div class="panel-body">
            <div class="panel-heading clearfix panel-theame">
                <span id="title_rs_main"><i class="fa fa-tasks"></i> Organization Chart</span>
            </div>
            <div class="container" style="margin-top:30px;">
                <div class="row">
                    <div class="col-md-12">
                        <ul id="tree1">
                            <?php
                            // Display the logged-in user's hierarchy
                            // Show the logged-in user first
                            $loggedInEmployee = Employee::model()->findByPk($loggedInUserId);
                            if ($loggedInEmployee) {
                                echo '<li><img src="uploads/profilephotos/' . (!empty($loggedInEmployee->profile_photo) ? $loggedInEmployee->profile_photo : 'emp.jpg') . '" width="50px" height="50px">  
                                <a href="#">' . CHtml::encode($loggedInEmployee->de_first_name) . ' ( ' . CHtml::encode($loggedInEmployee->designationdetail->designation_name) . ' / ' . $loggedInEmployee->hr_code . ' )</a>';

                                // Start displaying the hierarchy from the logged-in user's subordinates
                                display_employee_tree($employeeHierarchy, $loggedInUserId, [], $loggedInUserId);

                                echo '</li>';
                            }
                            ?>   
                            </ul>    

                        </div>
                    </div> 
                </div>
        </section>




        <script>
            $.fn.extend({
                treed: function (o) {

                    var openedClass = 'glyphicon-minus-sign';
                    var closedClass = 'glyphicon-plus-sign';

                    if (typeof o != 'undefined') {
                        if (typeof o.openedClass != 'undefined') {
                            openedClass = o.openedClass;
                        }
                        if (typeof o.closedClass != 'undefined') {
                            closedClass = o.closedClass;
                        }
                    }
                    ;

                    // Initialize each of the top levels
                    var tree = $(this);
                    tree.addClass("tree");
                    tree.find('li').has("ul").each(function () {
                        var branch = $(this); // li with children ul
                        branch.prepend("<i class='indicator glyphicon " + closedClass + "'></i>");
                        branch.addClass('branch');
                        branch.on('click', function (e) {
                            if (this == e.target) {
                                var icon = $(this).children('i:first');
                                icon.toggleClass(openedClass + " " + closedClass); // toggle the icon
                                $(this).children('ul').toggle(); // toggle the visibility of the nested ul
                            }
                        })
                        branch.children('ul').hide(); // Initially hide the child lists (ul)
                    });

                    // Open only the first level for #tree1
                    if (tree.attr('id') === 'tree1') {
                        // Open the direct children of the root (first level only)
                        tree.find('> li:has(ul)').each(function () {
                            var icon = $(this).children('i:first');
                            icon.toggleClass(openedClass + " " + closedClass); // Open the branch icon
                            $(this).children('ul').show(); // Show the nested ul (children of the first level)
                        });
                    }

                    // Fire event from the dynamically added icon
                    tree.find('.branch .indicator').each(function () {
                        $(this).on('click', function () {
                            $(this).closest('li').click();
                        });
                    });

                    // Fire event to open branch if the li contains an anchor instead of text
                    tree.find('.branch>a').each(function () {
                        $(this).on('click', function (e) {
                            $(this).closest('li').click();
                            e.preventDefault();
                        });
                    });

                    // Fire event to open branch if the li contains a button instead of text
                    tree.find('.branch>button').each(function () {
                        $(this).on('click', function (e) {
                            $(this).closest('li').click();
                            e.preventDefault();
                        });
                    });
                }
            });

            // Initialization of treeviews
            $('#tree1').treed();

            $('#tree2').treed({openedClass: 'glyphicon-folder-open', closedClass: 'glyphicon-folder-close'});

            $('#tree3').treed({openedClass: 'glyphicon-chevron-right', closedClass: 'glyphicon-chevron-down'});
        </script>
    </body>
</html>
