<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable(branch_id,id,desg,dept,status,team,report_id)
    {
        var table_id ="#tbl_employee_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
            bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/employee/GetEmployeeList') . '",
                type: "POST",
                "data" : {
                    "id" : id,"desg" : desg,"dept" : dept,"branch_id":branch_id,"status":status,"team":team,"report_id":report_id              
                },
                cache : false,
            },
            columnDefs: [
                       {
                       },
            ],
            order: [[ 3, "asc" ]],
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
            
        });
        $(".dataTables_scrollFoot").hide();
    }	
		
    $(document).ready(function() {  	 	
        var branch_id= $("#branch_id_val").val();
        var employee_id= $("#employee_id_val").val();	
        var desg= $("#employee_designation_val").val();	
        var dept= $("#employee_department_id_val").val();
        var team= $("#employee_teamname_val").val();
        var status = $("#active_emp_val").val();
        var report_id = $("#employee_reporting_manager_val").val();
        filterDataTable(branch_id,employee_id,desg,dept,status,team,report_id);
        materializing(".material");
    });', CClientScript::POS_HEAD);
$cs->registerScript("employeedetails", "function employeedetails(){  
    $('#tbl_employee_details').DataTable().destroy();
    var branch_id= $('#branch_id_val').val();
    var employee_id = $('#employee_id_val').val();
    var desg = $('#employee_designation_val').val();
    var dept = $('#employee_department_id_val').val();
    var team= $('#employee_teamname_val').val();
    var status = $('#active_emp_val').val();
    var report_id = $('#employee_reporting_manager_val').val();
    filterDataTable(branch_id,employee_id,desg,dept,status,team,report_id); 
};", CClientScript::POS_HEAD);
$cs->registerScript("BlockEmployee", "function BlockEmployee(id){
    var r = confirm('Are you sure to Block this Employee?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/employee/Block',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_employee_details');
                    t8.success(''+data.message+'');
                }else{
                    t8.error(''+data.message+'');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
$cs->registerScript("UnBlockEmployee", "function UnBlockEmployee(id){
    var r = confirm('Are you sure to UnBlock this Employee?');
        if(r==true)

        {

            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/employee/UnBlock',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('This Employee cant be UnBlocked');
                }else {
                    reloadTable('#tbl_employee_details');
                    t8.success('Employee UnBlocked SuccessFully!');

                }

               }

            });

        }
};", CClientScript::POS_HEAD);
$cs->registerScript("resetpassword", "function resetpassword(id){
    var r = confirm('Confirm password reset?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'dataType':'json',
              'url'  : $('#liveSite').val()+'index.php?r=hr/passwordchange/resetemployeepassword',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Password Changed and notification sent');
                }else {
                    t8.error('Error in resetting password');
                }

               }

            });

        }
};", CClientScript::POS_HEAD);
$cs->registerScript("getbranchemployees", "function getbranchemployees(){  
     var branch_id= $('#branch_id_val').val();
        jQuery.ajax({
           'dataType':'json',
            'data' : {'branch_id':branch_id},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/employee/employeebybranch') . "',
            'success': function(data) {
                $('#employee_id_val').html(data.employee);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);

$model_module_leave = HrModules::model()->findByPK(3);
$model_module_payroll = HrModules::model()->findByPK(7);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[8].edit_employee !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/employee/create&id=" + datas[8].id, datas[3], "xl");
                }
            };
        }
        if (datas[8].view_employee !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/employee/view&id=" + datas[8].id, datas[3], "xl");
                }
            };
        }

        if (datas[8].block_employee !== 0) {
            items.block = {
                name: (datas[8].isActive != "B") ? "Block" : "Unblock",
                icon: (datas[8].isActive != "B") ? "fa-ban" : "fa-retweet",
                callback: function () {
                    if (datas[8].isActive != "B") {
                        BlockEmployee(datas[8].id);
                    } else {
                        UnBlockEmployee(datas[8].id);
                    }
                }
            };
        }

        if (datas[8].reset_sent_password !== 0) {
            items.sendpassword = {
                name: "Reset Password",
                icon: "fa-lock",
                callback: function () {
                    resetpassword(datas[8].id);
                }
            };
        }

        if (datas[8].snapshot !== 0) {
            items.snapshot = {
                name: "Snapshot",
                icon: "fa-print",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/employee/printemployeesnapshotpdf&id=" + datas[8].en_id, "_blank");
                }
            };
        }

        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeeindexdropdown .material-select-label {
        display: none;
    }
</style>
<section class="panel" style="background-color:#F6F3EE; font-size: 10px;">
    <header class="panel-heading clearfix panel-theame emp"> Employees
        <a class="btn btn-sm btn-theme left" style=" margin: 2px 6px;" role="button" data-toggle="collapse" href="#collapseFilter" aria-expanded="false" aria-controls="collapseExample">
            More Filter
        </a>
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeindexdropdown">
                <span class="col-sm-3">
                    <?php echo CHtml::dropdownlist('branch_id_val', '', MasCompanyBranchSponsor::getCompanyBranches(), array('empty' => 'All Branches', 'data-label' => 'Branches', 'class' => '', 'title' => 'Please Select Branch', 'onchange' => 'getbranchemployees(); employeedetails();', 'data-search' => true, 'style' => 'width:150px;')); ?>                   
                </span>
                <span class="col-sm-3" id="li_emp_data">
                    <?php echo CHtml::dropdownlist('employee_id_val', '', Employee::getEmployee(), array('empty' => 'All Employees', 'title' => 'Please Select Employee', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   
                </span>
                <span class="col-sm-3">
                    <?php echo CHtml::dropdownlist('employee_department_id_val', '', MasDepartment::getDepartment(), array('empty' => 'All Departments', 'title' => 'Please Select Department', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   
                </span>
                <span class="col-sm-3">
                    <?php echo CHtml::dropdownlist('employee_designation_val', '', MasDesignation::getDesignation(), array('empty' => 'All Designations', 'title' => 'Please Select Designation', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>
                </span>
            </div>
            <?php
            $notice_flag = 0;
            $model_mas_company = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
            $total_employee_count = Employee::model()->count();
            if ($total_employee_count < $model_mas_company->total_employees_allowed) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_add']) || Yii::app()->user->authorised_user == 1) {
                    ?>
                    <a class="ad-btn pull-right" style="position: relative; top: 5px; left: 5px;" onclick="loadPopupModal('hr/employee/create', 'Add New Employee', 'xl')" title="Add">
                        <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                  &nbsp;
                    <?php
                }
                $model_upload_employee = HrMasterUpload::model()->findByPK(6);
                if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_upload']) || Yii::app()->user->authorised_user == 1) && ($model_upload_employee->isActive == 'Y')) {
                    ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employee/uploademployee', 'Upload Employees', 'lg')" title="Upload Basic Details"><i class="fa fa-user"></i> <i class="fa fa-upload"></i></button>  
                    <?php
                }
            } else {
                $notice_flag = 1;
            }
            $model_upload_salary = HrMasterUpload::model()->findByPK(7);
            if ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y' && $model_upload_salary->isActive == 'Y') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_salary_upload']) || Yii::app()->user->authorised_user == 1) {
                    ?>
                    <button class="btn btn-sm btn-theme " onclick="loadPopupModal('hr/employee/uploadsalary', 'Upload Salary', 'lg')" title="Upload Initial Salary Details"><i class="fa fa-money"></i> <i class="fa fa-upload"></i></button>  
                    <?php
                }
            }
            $model_upload_document = HrMasterUpload::model()->findByPK(9);
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_documents_upload']) || Yii::app()->user->authorised_user == 1) && ($model_upload_document->isActive == 'Y')) {
                ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employee/uploademployeedocuments', 'Upload Documents', 'lg')" title="Upload Documents Details"><i class="fa fa-book"></i> <i class="fa fa-upload"></i></button>  
                <?php
            }
            $model_upload_leave = HrMasterUpload::model()->findByPK(8);
            if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y' && $model_upload_leave->isActive == 'Y') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_leave_upload']) || Yii::app()->user->authorised_user == 1) {
                    ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employee/uploademployeeleave', 'Upload Leave Details', 'lg')" title="Upload Leave Details"><i class="fa fa-sign-out"></i> <i class="fa fa-upload"></i></button>  
                    <?php
                }
            }
            ?>
        </div>
        <div class="collapse pull-left" id="collapseFilter" style=" margin-top: 7px;">
            <div class="dis-flx">
                <div class="material col-sm-12 pd-zero" id="employeeindexdropdown">
                    <span class="col-sm-3 wdth">
                        <?php echo CHtml::dropdownlist('active_emp_val', 'Y', array('Y' => 'Current', 'N' => 'Old'), array('empty' => 'All Employees', 'class' => 'col-sm-2 form-control_1', 'title' => 'Employee Status', 'onchange' => 'employeedetails();', 'data-search' => true, 'style' => 'width:100px;')); ?>                   
                    </span>
                    <span class="col-sm-3 wdth">    
                        <?php echo CHtml::dropdownlist('employee_teamname_val', '', HrMasTeamName::getteam(), array('empty' => 'All Team', 'class' => 'col-sm-2 form-control_1', 'title' => 'Please Select Team', 'onchange' => 'employeedetails();', 'data-search' => true, 'style' => 'width:150px;')); ?>   
                    </span>
                    <span class="col-sm-3 wdth">      
                        <?php echo CHtml::dropdownlist('employee_reporting_manager_val', '', ReportingManager::getReportingManager(), array('empty' => 'All RM', 'class' => 'col-sm-2 form-control_1', 'title' => 'Please Select Reporting Manager', 'onchange' => 'employeedetails();', 'data-search' => true, 'style' => 'width:110px;')); ?>
                    </span>
                </div>
            </div>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <?php
            if ($notice_flag == 1) {
                ?>
                <div class="announcement-box">
                    <div class="announcement-icon blink-icon">
                        <i class="fa fa-bullhorn"></i>
                    </div>
                    <div class="announcement-text">
                        Please purchase additional license for adding new employees !!!
                    </div>
                </div>
            <?php } ?>
            <table class="table table-hover table-bordered personal-task" id="tbl_employee_details" style="font-size:12px;width: 100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Code</th>
                        <th>Employee Name</th>
                        <!--<th>Team</th>-->
                        <th>Department</th>  
                        <th>Designation</th>  
                        <th>Joining Date</th>
                        <th>RM</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
