<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'edit_dependant_document-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_dependent_document = HrMasterUpload::model()->findByPK(5);
$upload_dependent_size = $model_upload_dependent_document->max_upload_size * 1024 * 1024;
?>
<div class="out_border">
    <div class="row">
        <div class="col-md-12">
            <div class="personal_dett clearfix form-ul material">
                <div class="title text-center text-bold"><?php echo strtoupper('DEPENDANT DETAILS OF ' . $model->employeedetail->employeefullname); ?></div>
                <table class="per_dett">
                    <tbody>
                        <tr>
                            <td>Dependant Name</td><td><?php echo $model->dependant_name; ?></td>
                            <td>Document Name</td><td><?php echo $model->document->document_name; ?></td>
                            
                        </tr>
                        <tr>
                            <td>Date of Validity</td><td>
                                <?php
                                if ($model->renewal_date != '' && $model->renewal_date != '0000-00-00') {
                                    echo date("d/m/Y", strtotime($model->renewal_date));
                                }
                                ?>
                            </td>
                            <td>Document Attached</td><td>
                                <?php
                                if ($model->document_upload != '') {
                                    echo 'Yes';
                                } else {
                                    echo 'No';
                                }
                                ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php
                echo $form->hiddenField($model, 'id');
                echo $form->hiddenField($model, 'document_id');
                if ($model->renewal_date != '' && $model->renewal_date != '0000-00-00') {
                    $model->renewal_date = date("d/m/Y", strtotime($model->renewal_date));
                }
                echo $form->textField($model, 'renewal_date', array('data-label' => 'Date of Validity <span style="color:red">*</span>', 'class' => 'datepicker', 'onkeypress' => 'return false;'));
                ?>
            </li>  
            <?php if($model_upload_dependent_document->isActive=='Y'){ ?>
            <li class="col-sm-4">
                <label>Document Files</label>
                <?php
                 $allowedExtensions = array("csv", "zip", "png","pdf", "doc", "docx", "jpg", "jpeg","xls","xlsx");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/' . Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/documents/')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $upload_dependent_size,
                        'onStart' => "js:function(){}",
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            var val_doc =$('#EmployeeDependants_document_upload').val();
                            if(val_doc!=''){
                                $('#EmployeeDependants_document_upload').val(val_doc+','+responseJSON.filename); 
                            }else{
                                $('#EmployeeDependants_document_upload').val(responseJSON.filename); 
                            }     
                        }",
                    )
                ));
                ?>  
                <?php echo $form->hiddenField($model, 'document_upload'); ?>
            </li>
            <?php } ?>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="edit_document_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/hr/documentexpiry/UpdateDependantDetails');
    echo CHtml::ajaxsubmitButton('Update', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                t8.success("Dependant Document Details Updated Successfully!");
                $("#edit_document_close").click();
                reloadTable("#tbl_dependant_expiry");
            } else { 
                t8.error("Error in Updation"); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#edit_dependant_document-form .edit_document-btn").prop("disabled", true);
            $("#edit_dependant_document-form .edit_document-btn").addClass("btn_loding").removeClass("btn-theme");
        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#edit_dependant_document-form .edit_document-btn").prop("disabled", false);
            $("#edit_dependant_document-form .edit_document-btn").addClass("btn-theme").removeClass("btn_loding");
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'edit_document-btn btn btn-success'));
    ?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
?>