<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", '
        $(document).ready(function() {

        var table_id ="#tbl_disble_branch_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/disablepayslip/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
             "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            
              if ( aData[4].status == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                }      
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;
<?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit = 1;
<?php } ?>
<?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable = 1;
<?php } ?>
        $(row).contextMenu({
            selector: 'td',
            items: {
                "edit": {

                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("hr/disablepayslip/create&id=" + datas[4].id, datas[1], "md");
                    },
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                }



            }
        });
    }
</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=hr/disablepayslip/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_disble_branch_details').DataTable().ajax.reload()
                        t8.success(' Disabled/ Enabled Successfully!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Branch
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_disble_branch_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch Name</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
