<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'currency-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,

    ));

?>
<div class="tab-content">
    <div class="tab-pane active">
               <ul class="clearfix form-ul material">
                    <?php echo $form->hiddenField($model, 'id');?>
                    <li class="col-sm-4">
                           <?php echo $form->textField($model, 'currency',array('data-label'=>'Currency <span style="color:red">*</span>','data-validation'=>'required')); ?>
                    </li>
                    <li class="col-sm-4">
                           <?php echo $form->textField($model, 'currency_code',array('data-label'=>'Currency Code <span style="color:red">*</span>','data-validation'=>'required')); ?>
                    </li>
                    <li class="col-sm-4">
                           <?php echo $form->textField($model, 'exchange_rate',array('data-label'=>'Exchange Rate <span style="color:red">*</span>','data-validation'=>'required')); ?>
                    </li>
            </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="currency_close" data-dismiss="modal">Close</button>
    	<?php 
        $url = Yii::app()->createUrl('hr/Currency/SaveCurrency');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Currency Saved Successfully!");
                                         $("#currency_close").click();
                                        reloadTable("#tbl_currency_details");
                                    } else { 
                                        $("#currency-form .currency-save-btn").prop("disabled", false);
                                        $("#currency-form .currency-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                            $("#currency-form #"+key+"_em_").text(val).show(); 
                                            t8.error(""+val+""); 
                                        }); 
                                    } 
                                    }',
                            'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#currency-form .currency-save-btn").prop("disabled", true);
                                $("#currency-form .currency-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                            }'
                    ), array('id' => 'mybtn' . rand(), 'class' => 'currency-save-btn btn btn-theme'));
    ?>
    </div>
<?php $this->endWidget(); ?>










