<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("DeleteCircular", "function DeleteCircular(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/circular/DeleteCircular',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    reloadTable('#tbl_outdoorcircular_details'); 
                    t8.success('Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("loaddata", '$(document).ready(function() {
        var circular_type=2;
        var table_id ="#tbl_outdoorcircular_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/circular/GetList') . '",
                type: "POST",
                "data" : {"type" : circular_type},
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[4].edit_outcircular !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/circular/create&id="+datas[4].id, "Edit Circular", "lg");
                }
            };
        }
        if (datas[4].delete_outcircular !== 0) {
            items.Delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                     DeleteCircular(datas[4].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
         Outdoor Circular
        <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_outdoor_circular_add'])  || Yii::app()->user->authorised_user == 1) {?>
        <div class="pull-right">
            <a class="ad-btn" title="Add" onclick="loadPopupModal('hr/circular/create&type=2', 'Add New Circular', 'lg')">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
        </div>
        <?php } ?>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_outdoorcircular_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch Name</th>
                        <th>Title</th>
                        <th>Circular</th>
                    </tr>
                </thead>
                
            </table>
        </div>
    </div>
</section>
