<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-calendar"></i> -->
          Calendar
        <div class="pull-right"></div>
    </header>
    <div class="panel-body">
        <div id="employee_calendar"></div>
    </div>
</section>
<div class="color-indicator pull-left">
<?php
$model_color_code = HrMasColorCode::model()->findAll();
foreach ($model_color_code as $key => $value) {
?>
    <span style="display: inline-block;width:30px;height:30px; box-shadow: 0px 2px 10px 2px #F88017; background-color: <?php echo $value->color_code; ?>" class="bg-danger"></span><span class="verti"> <?php echo $value->functionality; ?></span>
<?php } ?>
</div>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("getCalendar", "$(document).ready(function(){
getCalendarEvents();

});", CClientScript::POS_READY);



$cs->registerScript("getCalendarEvents".rand(), "function getCalendarEvents(){
  var filter_id = $('#sel_event_type').val();
  $('#employee_calendar').fullCalendar({
            height: 600,
            contentHeight: 450,
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,basicWeek,basicDay'
            },
            dayClick: function(date, allDay, jsEvent, view) { $(this).addClass('selected-date');},
            eventClick: function(calEvent, jsEvent, view) {           
            },
            header: { left: 'prev,next today', center: 'title', right: 'month,agendaWeek,agendaDay'},
            buttonText: {
                today: 'T',
                month: 'M',
                agendaWeek: 'W',
                agendaDay: 'D'
            },
            defaultView: 'month',
            eventMouseover: function(calEvent, jsEvent) {
                var tooltip = '<div class=\"tooltipevent\">' +calEvent.description + '</div>';
                $(\"body\").append(tooltip);
                $(this).mouseover(function(e) {
                    $(this).css('z-index', 10000);
                    $('.tooltipevent').fadeIn('500');
                    $('.tooltipevent').fadeTo('10', 1.9);
                }).mousemove(function(e) {
                    $('.tooltipevent').css('top', e.pageY + 10);
                    $('.tooltipevent').css('left', e.pageX - 60);
                });
            },
            eventMouseout: function(calEvent, jsEvent) {
                $(this).css('z-index', 8);
                $('.tooltipevent').remove();
            },
            eventAfterRender:function (event, element) { },
            editable: true,
            eventLimit: true,
            //timeFormat: '',
            eventRender: function (calEvent, jsEvent) {
                var tooltip = calEvent.description;
                var type=calEvent.type;
                $(jsEvent).attr('data-original-title', tooltip);
                $(jsEvent).tooltip({ container: 'body',html:true});
                // $(jsEvent).find('.fc-event-time').remove();
                return ['all', calEvent.type].indexOf($('#filter_selector').val()) != ''
            },
            displayEventTime: false,
            loading: function( isLoading, view ) {
            if(isLoading) {// isLoading gives boolean value
              //  $('#loader').show();
            } else {
              //   $('#loader').hide();
            }
        },
            
            
        events: {
                url : '" . Yii::app()->createUrl('hr/calendar/getemployeeevent') . "',
            },            
        });
        
        
    }
", CClientScript::POS_READY);

?>
<style>
    #employee_calendar
{
background-color: #ebf3fa;
}
.fc-today {
    background: #FFF !important;
    border: none !important;
    border-top: 1px solid #ddd !important;
    font-weight: bold;
    font-size:14px;
} 
</style>
    