  <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'brand_salary-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
<div class="out_border">
    <div class="row">
        <div class="col-md-12">
            <div class="personal_dett clearfix form-ul material">
                <div class="title text-center"> BRAND SALARY PERCENTAGE OF <?php echo $employee_name; ?></div>
            </div>
        </div>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="brandsalary_item_table">
        <tr>
            <th>No</th> 
            <th>Brand</th>
            <th>%</th>
            <th class="text-center">
                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#brandsalary_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>
        <?php           
            foreach ($model as $i => $detail):                  
        ?>
        <tr>
            <td><label><?php echo ($i+1); ?></label></td>                   
            <td>
                 <?php echo CHtml::activeHiddenField($detail, "[" . $i . "]id"); ?>
                <?php  echo CHtml::activedropDownList($detail, "[" . $i . "]brand_id",ProductClass::getAllProductClass(), array('class'=>'tooltipster go','title' => 'Document','empty'=>'Select','onchange'=>'checkbrandexist(this.id);')); ?>                           
            </td>
           <td>
                <?php  echo CHtml::activeTextField($detail, "[" . $i . "]salary_percent", array('class'=>'go', 'placeholder' => '%', 'title' => '%','onkeypress' => 'return isNumberKey(event)','onkeyup'=>'checkpercentage(this.id);')); ?>                           
            </td>
            <td class="text-center nw" width="1%">
               <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removesalaryRow($(\'#brandsalary_item_table\'),this,this.id)
                                   ', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
    <input type="hidden" id="emply_id" name="emply_id" value="<?php echo $employee_id; ?>"/>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default " id="brand_close_1" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="savebrandsalary()">Save</button>
</div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript('checkbrandexist', 'function checkbrandexist(field_id) { 
    var arr_fields= field_id.split("_");
    var row_field=arr_fields[1];
    var brand_id=$("#EmployeeBrandSalaryPercent_"+row_field+"_brand_id").val(); 
    var table_length=$("#brandsalary_item_table").find("tr:gt(0)").length;  
    for(i=0;i<table_length;i++){
        var brand = $("#EmployeeBrandSalaryPercent_"+i+"_brand_id").val();
        if(brand_id==brand && row_field!=i){
            t8.error("Duplicate Brand in row "+parseInt(i+1));
            $("#EmployeeBrandSalaryPercent_"+row_field+"_brand_id").val("");
            $("#EmployeeBrandSalaryPercent_"+row_field+"_salary_percent").val("");
        }
    }
};', CClientScript::POS_HEAD);
$cs->registerScript('checkpercentage', 'function checkpercentage(field_id) { 
    var arr_fields= field_id.split("_");
    var row_field=arr_fields[1];
    var table_length=$("#brandsalary_item_table").find("tr:gt(0)").length;  
    var total=0.00;
    for(i=0;i<table_length;i++){
        var salary_percent = $("#EmployeeBrandSalaryPercent_"+i+"_salary_percent").val();
        if(Number(salary_percent)>0){
            total+=Number(salary_percent);
        }
    }
    if(Number(total)>100){
        t8.error("Total Percentage cannot be greater than 100");
        $("#EmployeeBrandSalaryPercent_"+row_field+"_salary_percent").val("");
    }
};', CClientScript::POS_HEAD);
$cs->registerScript("savebrandsalary", "function savebrandsalary() {
   jQuery.ajax({
      'dataType':'json',
      'data' : $('#brand_salary-form').serialize(),
      'type':'post',
      'url': '" . Yii::app()->createUrl('brandsalary/UpdateSalaryPercent') . "',
      'cache': false,
      'success': function(data) {
            if(data.status=='success'){
                t8.success('Saved Successfully!');
                $('#brand_close_1').click();
                reloadTable('#tbl_brandsalary_details');
            }
            else{
                $.each(data, function(key, val) {
                    t8.error(''+val+'');
                });
            }

        },
        'beforeSend':function(){
            $('.toast8-error').hide(); 
            var table_length=$('#brandsalary_item_table').find('tr:gt(0)').length;  
            var total=0.00;
            for(i=0;i<table_length;i++){
                var salary_percent = $('#EmployeeBrandSalaryPercent_'+i+'_salary_percent').val();
                if(Number(salary_percent)>0){
                    total+=Number(salary_percent);
                }
            }
            if(Number(total)<100){
                t8.error('Total Percentage cannot be less than 100');
                return false;
            }else{
                $('#loader').show();  
            }
        },
        'complete':function(){
            $('#loader').hide();                                                                
        }
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("removesalaryRow", "function removesalaryRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#EmployeeBrandSalaryPercent_'+arr_fields+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('brandsalary/deletebrandsalary') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Deleted');
                        }else{
                            t8.error('Deletion Not Possible, History Exist');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);
?>










