<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("DisableBank", "function DisableBank(id){
    var r = confirm('Are you sure to disable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/bank/DisableBank',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=hr/bank/index';
                    t8.success('Bank Disabled SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>
<script>
    $(document).ready(function () {
    var table_id = "#tbl_bank_details";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.display_type = $("#display_type").val();
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
            url: "<?php echo Yii::app()->createUrl('hr/bank/GetBankList') ?>",
                    type: "POST",
                    cache: false
            },
            serverSide: true,
            fixedColumns: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            if (aData[4].isActive == "N")  {
            $("td", nRow).addClass("bg-danger");
            }
            }
    });
    });
    function AddContextMenu(row, datas) { 
        let items = {};
        if (datas[4].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/bank/create&id=" + datas[4].id, datas[4].code, "lg");
                }
            };
        }
        if (datas[4].disable_button !== 0) {
            items.Disable_Enable = {
                name: (datas[4].isActive== "Y") ? "Disable" : "Enable",
                icon: (datas[4].isActive == "Y") ? "fa-toggle-off" : "fa-toggle-on",
                callback: function () {
                   DisableBank(datas[4].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Bank Details
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_bank_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/bank/create', 'Add New Bank', 'lg')"><i class="fa fa-plus"></i></button> -->
                
                     <a class="ad-btn"  onclick="loadPopupModal('hr/bank/create','Add New Bank','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_bank_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Bank Name</th>
                        <th>Bank Code</th>
                        <th>Routing Code</th>

                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
