<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'emp_attendance_upload_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>

<div class="tab-content">

    <div class="tab-pane active">

        <ul class="clearfix form-ul material">            
            <li class="col-sm-4">
                <?php echo CHtml::dropdownlist('attendance_brnch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('prompt' => '--Select--', 'data-label' => 'Branch <span style="color : red;"> *</span>', 'data-search'=>true,'class' => 'tooltipster', 'title' => 'Please select Branch')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::textField('attendance_date_from', date("d/m/Y"), array('class' => 'datepicker', 'data-label' => 'Date', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-4">
                <a href="javascript:void(0);" onclick="loademployeeattendance();" class="btn btn-primary">Load</a>          
            </li>
        </ul>

    </div>
</div>
<div class="btn-wrap">  
    <div id="div_attendance_absent_employees_list"></div>
</div>
<input type="hidden" id="attend_strt_date" value="<?php echo date('d/m/Y', strtotime('+1 day', strtotime(date('Y-m-d')))); ?>" />    
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    var min_date = $('#attend_strt_date').val().split('/');
    var min_date = new Date(min_date[2], min_date[1] - 1, min_date[0]);
    $('#attendance_date_from').datetimepicker({minDate: min_date, format: 'DD/MM/YYYY'});
});", CClientScript::POS_HEAD);
$cs->registerScript("loademployeeattendance", "function loademployeeattendance() {
        var from_date = $('#attendance_date_from').val();
        var attendancebranch = $('#attendance_brnch').val();
        var date_from = from_date.split('/').reverse().join('-');  
        if(date_from!='' && attendancebranch!=''){
            jQuery.ajax({
                'data' : {
                    'attendancebranch':attendancebranch,
                    'from_date':date_from
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/attendance/ListEmployee') . "',
                'cache': false,
                'success': function(data) {
                    $('#div_attendance_absent_employees_list').html(data);
                },
                'beforeSend': function(data) {
                    $('#loader').show();
                },
                'complete': function(data) {
                    $('#loader').hide();
                },
        });
        }else{
            if(date_from=='' && attendancebranch==''){
              t8.error('Select Date and Branch');
            }else if(date_from==''){
                t8.error('Select Date');
            }else if(attendancebranch==''){
                t8.error('Select Branch');
            }
           
        }
    };", CClientScript::POS_HEAD);
?>

