<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'emp_attenendance_upload_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist('attendance_branch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('prompt' => '--Select--', 'data-label' => 'Branch <span style="color : red;">*</span>', 'class' => 'tooltipster', 'title' => 'Please select Branch','onchange'=>'getpayrolldatebybranch(this.value);')); ?>
            </li>
            <li class="col-sm-3">  
                <?php echo CHtml::textField('attendance_startdate','',array('class' => '','data-label'=>'Date From <span style="color:red">*</span>','readonly'=>true)); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::textField('attendance_enddate','',array('class' => 'datepicker','data-label'=>'Date To <span style="color:red">*</span>','onkeypress' => 'return false;')); ?>
            </li>   
             <li class="col-sm-3">
                <?php echo CHtml::textField('attendance_month','',array('data-label'=>'Month <span style="color:red">*</span>','readonly'=>true)); ?>
            </li>   
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" id="attendance_autosave_close_btn" class="btn btn-danger" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="saveautoaddattendance();">Save</button>
</div>  
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getpayrolldatebybranch", "function getpayrolldatebybranch(branch_id) {
    if(branch_id!=''){
        jQuery.ajax({
            'dataType':'json',
            'data' : {'branch_id':branch_id},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/salary/getpayrolldatebybranch') . "',
            'cache': false,
            'success': function(data) {
                if(data.status=='success'){
                    $('#attendance_month').addClass('filled');
                    $('#attendance_startdate').addClass('filled');
                    $('#attendance_enddate').addClass('filled');
                    $('#attendance_month').val(data.month);
                    $('#attendance_startdate').val(data.start);
                    $('#attendance_enddate').val(data.end);
                }else{
                    t8.error('Error');
                } 
            },         
        });   
    }else{
        $('#attendance_month').val('');
        $('#attendance_startdate').val('');
        $('#attendance_enddate').val('');
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("saveautoaddattendance", "function saveautoaddattendance() {
    $('.toast8-error').hide(); 
    var branch  = $('#attendance_branch').val();
    var startdate  = $('#attendance_startdate').val();
    var enddate  = $('#attendance_enddate').val();
    if(startdate!='' && enddate!='' && branch!=''){
        jConfirm('Confirm Auto Save of attendance for the period  '+startdate+'-'+enddate+'?', 'Confirmation Dialog', function(r) {
            if (r == true) {
                    jQuery.ajax({
                        'dataType':'json',
                        'data' : {'branch':branch,'startdate':startdate,'enddate':enddate},
                        'type':'post',
                        'url': '" . Yii::app()->createUrl('hr/attendance/saveautoaddattendance') . "',
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $('#attendance_autosave_close_btn').click(); 
                                t8.success('Attendance Saved successfully');
                            }else{
                                t8.error('Error in Saving Attendance');
                            }
                        }, 
                        'beforeSend':function(){
                          $('#loader').show();                      
                        },
                        'complete':function(){
                            $('#loader').hide();   
                        }
                    });     
                }
            }); 
    }else{
        if(branch==''){
            t8.error('Select Branch');
        }else if(startdate==''){
            t8.error('Select Start Date ');
        }else if(enddate==''){
            t8.error('Select End Date ');
        }
    }
};", CClientScript::POS_HEAD);
?>

