<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'emp_attenendance_delete_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">            
            <li class="col-sm-6">
                <?php echo CHtml::dropdownlist('delete_branch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('prompt' => '--Select--', 'data-label' => 'Branch','data-search'=>true,'class' => 'tooltipster', 'title' => 'Please select Branch','onchange'=>'getpayrolldatebybranch(this.value);')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('delete_date_from', date("d/m/Y"), array('class' => 'datepicker', 'data-label' => 'Date', 'onkeypress' => 'return false;')); ?>
            </li>
        </ul>
    </div>
    <input type="hidden" id="max_date" value="<?php echo date("d/m/Y"); ?>" />    
    <input type="hidden" id="payroll_date" value="<?php echo $payroll_enddate; ?>" />    
</div>
<div class="modal-footer">
        <button type="button" class="btn btn-theme " id="delte_atte" onclick="deleteattendance();">Delete</button>
        <button type="button" class="btn btn-danger" id="delete_close" data-dismiss="modal">Close</button>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    setdate();
});", CClientScript::POS_HEAD);
$cs->registerScript("setdate", "function setdate() { 
    var max_date = $('#max_date').val().split('/');
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
       $('#delete_date_from').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
        var min_date = $('#payroll_date').val().split('/');
        var min_date = new Date(min_date[2], min_date[1] - 1, min_date[0]);
//       $('#delete_date_from').datetimepicker({minDate: min_date, format: 'DD/MM/YYYY'}); 
        $('#delete_date_from').data('DateTimePicker').minDate(min_date);
};", CClientScript::POS_HEAD);

$cs->registerScript("deleteattendance", "function deleteattendance() {
    var branch  = $('#delete_branch').val();
    var date_delete  = $('#delete_date_from').val();
    if(date_delete!=''){
        jConfirm('Confirm deletion of attendance on this date?', 'Confirmation Dialog', function(r) {
            if (r == true) {
                    jQuery.ajax({
                        'dataType':'json',
                        'data' : {'branch':branch,'date_delete':date_delete},
                        'type':'post',
                        'url': '" . Yii::app()->createUrl('hr/attendance/deleteattendancebydate') . "',
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $('#delete_close').click(); 
                                t8.success('Deleted successfully');
                            }else if(data.status=='error'){
                                t8.error('Deletion Failed');
                            }
                        }, 
                        'beforeSend':function(){
                          $('#loader').show();                      
                        },
                        'complete':function(){
                            $('#loader').hide();   
                        }
                    });     
                }
            }); 
    }else{
        if(date_delete==''){
            t8.error('Select Date');
        }
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("getpayrolldatebybranch", "function getpayrolldatebybranch(branch_id) {
    jQuery.ajax({
        'dataType':'json',
        'data' : {'branch_id':branch_id},
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/attendance/getpayrolldatebybranch') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                $('#payroll_date').val(data.payroll_date);
                setdate();
            }else{
                t8.error('Error');
            } 
        },         
    });     
};", CClientScript::POS_HEAD);
?>

